/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.config.PDFConfig;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;

public final class PdfConfigurationProcessor
extends AbstractProcessor<In, Void> {
    private Map<String, Update> updates;

    public PdfConfigurationProcessor() {
        super(Void.class);
    }

    public void setUpdates(Map<String, Object> updates) {
        HashMap finalUpdatesMap = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : updates.entrySet()) {
            Update update;
            String property = entry.getKey();
            if (entry.getValue() instanceof Update) {
                update = (Update)entry.getValue();
                update.property = property;
            } else if (entry.getValue() instanceof String) {
                String value = (String)entry.getValue();
                update = new Update();
                update.property = property;
                update.setValueKey(value);
            } else {
                throw new IllegalArgumentException("Update property " + property + " has a non-string and non-!updatePdfConfigUpdate " + "value: " + entry.getValue() + "(" + entry.getValue().getClass() + ")");
            }
            finalUpdatesMap.put(property, update);
        }
        this.updates = finalUpdatesMap;
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (this.updates == null) {
            validationErrors.add(new ConfigurationException("The property 'attributeMap' in the !updatePdfConfig processor is required"));
        } else {
            if (this.updates.isEmpty()) {
                validationErrors.add(new ConfigurationException("At least one value for 'attributeMap' in !updatePdfConfig should be declared."));
            }
            for (Map.Entry<String, Update> entry : this.updates.entrySet()) {
                entry.getValue().validate(validationErrors, configuration);
            }
        }
    }

    @Override
    @Nullable
    public In createInputParameter() {
        return new In();
    }

    @Override
    @Nullable
    public Void execute(In in, Processor.ExecutionContext context) throws Exception {
        for (Map.Entry<String, Update> entry : this.updates.entrySet()) {
            List<String> value = this.getAttributeValue(entry.getValue().valueKey, in.values);
            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(PDFConfig.class, (String)entry.getValue().property);
            String format = entry.getValue().format;
            if (format != null) {
                value = String.format(format, value);
            }
            MethodParameter writeMethodParameter = BeanUtils.getWriteMethodParameter((PropertyDescriptor)propertyDescriptor);
            try {
                if (propertyDescriptor.getName().equals("keywords")) {
                    value = this.convertKeywords(value);
                }
                writeMethodParameter.getMethod().invoke((Object)in.pdfConfig, value);
            }
            catch (Throwable e) {
                if (writeMethodParameter == null) {
                    throw new RuntimeException("An error occurred while executing !updatePdfConfig.  Unable to set configuration property '" + entry.getKey() + " with value " + value + ". ");
                }
                throw new RuntimeException("An error occurred while executing !updatePdfConfig.  Unable to set configuration property '" + entry.getKey() + " with value " + value + ". The expected type is " + writeMethodParameter.getParameterType() + " but the type of the value being set was: " + (value != null ? value.getClass() : "null"));
            }
        }
        return null;
    }

    private List<String> convertKeywords(@Nullable Object keywordsObj) {
        if (keywordsObj == null) {
            return Collections.emptyList();
        }
        if (keywordsObj instanceof Iterable) {
            Iterable obj = (Iterable)keywordsObj;
            ArrayList list = Lists.newArrayList();
            for (Object keyword : obj) {
                list.add(keyword.toString());
            }
            return list;
        }
        if (keywordsObj.getClass().isArray()) {
            Object[] arr = (Object[])keywordsObj;
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < arr.length; ++i) {
                Object keyword = arr[i];
                list.add(keyword.toString());
            }
            return list;
        }
        String s = keywordsObj.toString();
        if (s.contains(",")) {
            return Lists.newArrayList(Arrays.asList(s.split(",")));
        }
        return Lists.newArrayList((Object[])new String[]{s});
    }

    private Object getAttributeValue(String attributeName, Values values) {
        String[] parts = attributeName.split("\\.");
        Object value = values.getObject(parts[0], Object.class);
        for (int i = 1; i < parts.length; ++i) {
            this.assertNonnullValue(attributeName, values, value);
            String part = parts[i];
            try {
                Field field = value.getClass().getField(part);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                value = field.get(value);
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("No field " + part + " in object: " + value.getClass() + ". This error is part of the processor " + "!updatePdfConfig for the value: " + attributeName);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Not permitted to access" + part + " in object: " + value.getClass() + ".  This is likely caused by the " + "Java security manager. This error is part of the processor " + "!updatePdfConfig for the value: " + attributeName);
            }
        }
        this.assertNonnullValue(attributeName, values, value);
        return value;
    }

    private void assertNonnullValue(String attributeName, Values values, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(attributeName + " does not identify a value that is currently in the values object.  " + "Values object is: \n" + values);
        }
    }

    public static final class Update
    implements ConfigurationObject {
        private String property;
        private String valueKey;
        private String format;

        public Update() {
        }

        Update(String valueKey, String format) {
            this.valueKey = valueKey;
            this.format = format;
        }

        @Override
        public void validate(List<Throwable> validationErrors, Configuration configuration) {
            if (this.valueKey.isEmpty()) {
                validationErrors.add(new ConfigurationException("The value of '" + this.property + "' should not be empty. Error in !updatePdfConfig"));
                return;
            }
            if (this.valueKey.charAt(0) == '.') {
                validationErrors.add(new ConfigurationException("The value of '" + this.property + "' should start with a '.', it was " + this.valueKey + ". Error in !updatePdfConfig"));
                return;
            }
            String[] attributeAccessorDefinition = this.valueKey.split("\\.");
            if (attributeAccessorDefinition.length == 0) {
                validationErrors.add(new ConfigurationException(this.property + ": " + this.valueKey + " is not a valid mapping in !updatePdfConfig"));
                return;
            }
            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(PDFConfig.class, (String)this.property);
            if (propertyDescriptor == null || BeanUtils.getWriteMethodParameter((PropertyDescriptor)propertyDescriptor) == null) {
                PropertyDescriptor[] descriptors = BeanUtils.getPropertyDescriptors(PDFConfig.class);
                StringBuilder options = new StringBuilder();
                for (PropertyDescriptor descriptor : descriptors) {
                    options.append("\n\t* ").append(descriptor.getName());
                }
                validationErrors.add(new ConfigurationException("There is no pdf config property called '" + this.property + "'. Options include: " + options));
            }
        }

        public void setValueKey(String valueKey) {
            this.valueKey = valueKey;
        }

        public void setFormat(String format) {
            this.format = format;
        }
    }

    public static class In {
        @InternalValue
        public Values values;
        @InternalValue
        public PDFConfig pdfConfig;
    }
}

