/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.google.common.base.Optional;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.config.access.AccessAssertionPersister;
import org.mapfish.print.servlet.job.FailedPrintJob;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.job.PendingPrintJob;
import org.mapfish.print.servlet.job.SuccessfulPrintJob;
import org.mapfish.print.servlet.registry.Registry;

public abstract class PrintJobStatus {
    private static final String RESULT_METADATA = "resultMetadata_";
    private static final String JSON_APP = "appId";
    private static final String JSON_FILENAME = "fileName";
    private static final String JSON_SUCCESS = "success";
    private static final String JSON_ACCESS_ASSERTION = "access";
    private static final String JSON_COMPLETION_DATE = "completionDate";
    private final String referenceId;
    private final String appId;
    private final String fileName;
    private Date completionDate;
    private final AccessAssertion access;

    public PrintJobStatus(String referenceId, String appId, Date completionDate, String fileName, AccessAssertion accessAssertion) {
        this.referenceId = referenceId;
        this.appId = appId;
        this.completionDate = completionDate;
        this.fileName = fileName;
        this.access = accessAssertion;
        accessAssertion.assertAccess(this.getClass().getSimpleName() + " for app '" + appId + "' for print job '" + referenceId + "'", this);
    }

    public final void store(Registry registry, AccessAssertionPersister persister) throws JSONException {
        JSONObject metadata = new JSONObject();
        metadata.put(JSON_APP, (Object)this.appId);
        metadata.put(JSON_FILENAME, (Object)this.fileName);
        metadata.put(JSON_SUCCESS, this instanceof SuccessfulPrintJob);
        if (this.completionDate != null) {
            metadata.put(JSON_COMPLETION_DATE, this.completionDate.getTime());
        }
        metadata.put(JSON_ACCESS_ASSERTION, (Object)persister.marshal(this.access));
        this.addExtraParameters(metadata);
        registry.put(RESULT_METADATA + this.referenceId, metadata);
    }

    protected abstract void addExtraParameters(JSONObject var1) throws JSONException;

    public static Optional<? extends PrintJobStatus> load(String referenceId, Registry registry, AccessAssertionPersister persister) throws JSONException, NoSuchReferenceException {
        if (registry.containsKey(RESULT_METADATA + referenceId)) {
            PrintJobStatus report;
            JSONObject metadata = registry.getJSON(RESULT_METADATA + referenceId);
            String appId = metadata.optString(JSON_APP, null);
            JSONObject accessJSON = metadata.getJSONObject(JSON_ACCESS_ASSERTION);
            AccessAssertion accessAssertion = persister.unmarshal(accessJSON);
            if (!metadata.has(JSON_COMPLETION_DATE)) {
                report = PendingPrintJob.load(metadata, referenceId, appId, accessAssertion);
            } else {
                String fileName = metadata.getString(JSON_FILENAME);
                Date completionDate = new Date(metadata.getLong(JSON_COMPLETION_DATE));
                report = metadata.getBoolean(JSON_SUCCESS) ? SuccessfulPrintJob.load(metadata, referenceId, appId, completionDate, fileName, accessAssertion) : FailedPrintJob.load(metadata, referenceId, appId, completionDate, fileName, accessAssertion);
            }
            return Optional.of((Object)report);
        }
        throw new NoSuchReferenceException("invalid reference '" + referenceId + "'");
    }

    public final String getReferenceId() {
        return this.referenceId;
    }

    public final String getAppId() {
        return this.appId;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final Date getCompletionDate() {
        return this.completionDate;
    }

    public final AccessAssertion getAccess() {
        return this.access;
    }
}

