/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import java.util.Date;
import java.util.concurrent.Future;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.servlet.job.PrintJobStatus;

public class SubmittedPrintJob {
    private final String reportRef;
    private final String appId;
    private final Future<PrintJobStatus> reportFuture;
    private final long startTime = new Date().getTime();
    private final AccessAssertion accessAssertion;

    public SubmittedPrintJob(Future<PrintJobStatus> reportFuture, String reportRef, String appId, AccessAssertion accessAssertion) {
        this.reportFuture = reportFuture;
        this.reportRef = reportRef;
        this.appId = appId;
        this.accessAssertion = accessAssertion;
    }

    public final String getReportRef() {
        return this.reportRef;
    }

    public final String getAppId() {
        return this.appId;
    }

    public final Future<PrintJobStatus> getReportFuture() {
        return this.reportFuture;
    }

    public final long getTimeSinceStart() {
        return System.currentTimeMillis() - this.startTime;
    }

    public final AccessAssertion getAccessAssertion() {
        return this.accessAssertion;
    }
}

