/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import com.google.common.collect.Sets;
import java.util.Set;
import jsr166y.ForkJoinPool;
import org.geotools.data.FeatureSource;
import org.geotools.styling.Style;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.MapLayerFactoryPlugin;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.style.StyleParser;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractFeatureSourceLayerPlugin<P>
implements MapLayerFactoryPlugin<P> {
    @Autowired
    protected StyleParser parser;
    @Autowired
    protected ForkJoinPool forkJoinPool;
    private final Set<String> typeNames;

    public AbstractFeatureSourceLayerPlugin(String typeName, String ... typeNames) {
        this.typeNames = Sets.newHashSet((Object[])typeNames);
        this.typeNames.add(typeName);
    }

    @Override
    public final Set<String> getTypeNames() {
        return this.typeNames;
    }

    protected final StyleSupplier<FeatureSource> createStyleFunction(final Template template, final String styleString) {
        return new StyleSupplier<FeatureSource>(){

            @Override
            public Style load(MfClientHttpRequestFactory requestFactory, FeatureSource featureSource, MapfishMapContext mapContext) {
                if (featureSource == null) {
                    throw new IllegalArgumentException("Feature source cannot be null");
                }
                String geomType = featureSource.getSchema().getGeometryDescriptor().getType().getBinding().getSimpleName();
                String styleRef = styleString;
                if (styleRef == null) {
                    styleRef = geomType;
                }
                StyleParser styleParser = AbstractFeatureSourceLayerPlugin.this.parser;
                return (Style)template.getStyle(styleRef, mapContext).or(styleParser.loadStyle(template.getConfiguration(), requestFactory, styleRef, mapContext)).or((Object)template.getConfiguration().getDefaultStyle(geomType));
            }
        };
    }

    public final void setParser(StyleParser parser) {
        this.parser = parser;
    }
}

