/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FileUtils;
import org.mapfish.print.URIUtils;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayer;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayerPlugin;
import org.mapfish.print.map.geotools.AbstractVectorLayerParam;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.xml.sax.SAXException;

public final class GmlLayer
extends AbstractFeatureSourceLayer {
    public GmlLayer(ExecutorService executorService, FeatureSourceSupplier featureSourceSupplier, StyleSupplier<FeatureSource> styleSupplier, boolean renderAsSvg, AbstractLayerParams params) {
        super(executorService, featureSourceSupplier, styleSupplier, renderAsSvg, params);
    }

    public static class GmlParam
    extends AbstractVectorLayerParam {
        public String url;
    }

    public static final class Plugin
    extends AbstractFeatureSourceLayerPlugin<GmlParam> {
        private static final String TYPE = "gml";
        private static final GMLConfiguration GML_2_PARSER = new GMLConfiguration();
        private static final org.geotools.gml3.GMLConfiguration GML_3_PARSER = new org.geotools.gml3.GMLConfiguration();
        private static final org.geotools.gml3.v3_2.GMLConfiguration GML_32_PARSER = new org.geotools.gml3.v3_2.GMLConfiguration(true);

        public Plugin() {
            super(TYPE, new String[0]);
        }

        @Override
        public GmlParam createParameter() {
            return new GmlParam();
        }

        @Nonnull
        public GmlLayer parse(Template template, @Nonnull GmlParam param) throws IOException {
            return new GmlLayer((ExecutorService)this.forkJoinPool, this.createFeatureSourceSupplier(template, param.url), this.createStyleFunction(template, param.style), template.getConfiguration().renderAsSvg(param.renderAsSvg), param);
        }

        private FeatureSourceSupplier createFeatureSourceSupplier(final Template template, final String url) {
            return new FeatureSourceSupplier(){

                @Override
                @Nonnull
                public FeatureSource load(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext mapContext) {
                    SimpleFeatureCollection featureCollection;
                    try {
                        featureCollection = Plugin.this.createFeatureSource(template, requestFactory, url);
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.getRuntimeException(e);
                    }
                    if (featureCollection == null) {
                        throw new IllegalArgumentException(url + " does not reference a GML file");
                    }
                    return new CollectionFeatureSource(featureCollection);
                }
            };
        }

        private SimpleFeatureCollection createFeatureSource(Template template, MfClientHttpRequestFactory httpRequestFactory, String gmlString) throws IOException {
            try {
                URL url = new URL(gmlString);
                FileUtils.testForLegalFileUrl(template.getConfiguration(), url);
                try {
                    String gmlData = URIUtils.toString(httpRequestFactory, url.toURI());
                    int endIndex = 200;
                    String startOfData = gmlData.substring(0, 200);
                    if (startOfData.contains("\"http://www.opengis.net/gml/3.2\"")) {
                        return this.parseGml32(gmlData);
                    }
                    return this.parseGml3(gmlData);
                }
                catch (URISyntaxException e) {
                    throw ExceptionUtils.getRuntimeException(e);
                }
            }
            catch (MalformedURLException e) {
                return null;
            }
        }

        private SimpleFeatureCollection parseGml3(String gmlData) throws IOException {
            Parser gmlV3Parser = new Parser((Configuration)GML_3_PARSER);
            gmlV3Parser.setStrict(false);
            gmlV3Parser.setRootElementType(new QName("http://www.opengis.net/wfs", "FeatureCollection"));
            try {
                Object featureCollection = gmlV3Parser.parse((Reader)new StringReader(gmlData));
                if (featureCollection != null) {
                    return (SimpleFeatureCollection)featureCollection;
                }
            }
            catch (SAXException e) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            return this.parseGml2(gmlData);
        }

        private SimpleFeatureCollection parseGml2(String gmlData) throws IOException {
            Parser gmlV2Parser = new Parser((Configuration)GML_2_PARSER);
            gmlV2Parser.setStrict(false);
            gmlV2Parser.setRootElementType(new QName("http://www.opengis.net/wfs", "FeatureCollection"));
            try {
                Object featureCollection = gmlV2Parser.parse((Reader)new StringReader(gmlData));
                if (featureCollection != null) {
                    return (SimpleFeatureCollection)featureCollection;
                }
            }
            catch (SAXException e) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            return this.parseGml32(gmlData);
        }

        private SimpleFeatureCollection parseGml32(String gmlData) throws IOException {
            Parser gmlV32Parser = new Parser((Configuration)GML_32_PARSER);
            gmlV32Parser.setStrict(false);
            gmlV32Parser.setRootElementType(new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection"));
            try {
                Object featureCollection = gmlV32Parser.parse((Reader)new StringReader(gmlData));
                if (featureCollection != null) {
                    return (SimpleFeatureCollection)featureCollection;
                }
                throw new RuntimeException("unable to parse gml: \n\n" + gmlData);
            }
            catch (SAXException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
            catch (ParserConfigurationException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
        }
    }
}

