/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import jsr166y.ForkJoinPool;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayerPlugin;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.geotools.grid.GridLayer;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.LinearCoordinateSequence;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.springframework.beans.factory.annotation.Autowired;

public final class GridLayerPlugin
extends AbstractFeatureSourceLayerPlugin<GridParam> {
    private static final String TYPE = "grid";
    @Autowired
    private ForkJoinPool pool;

    public GridLayerPlugin() {
        super(TYPE, new String[0]);
    }

    @Override
    public GridParam createParameter() {
        return new GridParam();
    }

    @Nonnull
    public GridLayer parse(@Nonnull Template template, @Nonnull GridParam layerData) throws Throwable {
        FeatureSourceSupplier featureSource = this.createFeatureSourceFunction(template, layerData);
        StyleSupplier<FeatureSource> styleFunction = this.createStyleSupplier(template, layerData);
        return new GridLayer((ExecutorService)this.pool, featureSource, styleFunction, template.getConfiguration().renderAsSvg(layerData.renderAsSvg), layerData);
    }

    private StyleSupplier<FeatureSource> createStyleSupplier(final Template template, final GridParam layerData) {
        return new StyleSupplier<FeatureSource>(){

            @Override
            public Style load(MfClientHttpRequestFactory requestFactory, FeatureSource featureSource, MapfishMapContext mapContext) {
                String styleRef = layerData.style;
                return (Style)template.getStyle(styleRef, mapContext).or(GridLayerPlugin.this.parser.loadStyle(template.getConfiguration(), requestFactory, styleRef, mapContext)).or((Object)template.getConfiguration().getDefaultStyle(GridLayerPlugin.TYPE));
            }
        };
    }

    private FeatureSourceSupplier createFeatureSourceFunction(Template template, final GridParam layerData) {
        return new FeatureSourceSupplier(){

            @Override
            @Nonnull
            public FeatureSource load(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext mapContext) {
                SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
                CoordinateReferenceSystem projection = mapContext.getBounds().getProjection();
                typeBuilder.add("geom", LineString.class, projection);
                typeBuilder.add("label", String.class);
                typeBuilder.add("rotation", Double.class);
                typeBuilder.add("xDisplacement", Double.class);
                typeBuilder.add("yDisplacement", Double.class);
                typeBuilder.setName(GridLayerPlugin.TYPE);
                SimpleFeatureType featureType = typeBuilder.buildFeatureType();
                SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
                DefaultFeatureCollection features = layerData.numberOfLines != null ? GridLayerPlugin.this.createFeaturesFromNumberOfLines(mapContext, featureBuilder, layerData) : GridLayerPlugin.this.createFeaturesFromSpacing(mapContext, featureBuilder, layerData);
                return new CollectionFeatureSource((SimpleFeatureCollection)features);
            }
        };
    }

    @Nonnull
    private DefaultFeatureCollection createFeaturesFromNumberOfLines(@Nonnull MapfishMapContext mapContext, @Nonnull SimpleFeatureBuilder featureBuilder, @Nonnull GridParam layerData) {
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        double xSpace = bounds.getWidth() / (double)(layerData.numberOfLines[0] + 1);
        double ySpace = bounds.getHeight() / (double)(layerData.numberOfLines[1] + 1);
        double minX = bounds.getMinimum(0) + xSpace;
        double minY = bounds.getMinimum(1) + ySpace;
        return this.sharedCreateFeatures(featureBuilder, layerData, mapContext, xSpace, ySpace, minX, minY);
    }

    @Nonnull
    private DefaultFeatureCollection createFeaturesFromSpacing(@Nonnull MapfishMapContext mapContext, @Nonnull SimpleFeatureBuilder featureBuilder, @Nonnull GridParam layerData) {
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        double xSpace = layerData.spacing[0];
        double ySpace = layerData.spacing[1];
        double minX = this.calculateFirstLine(bounds, layerData, 0);
        double minY = this.calculateFirstLine(bounds, layerData, 1);
        return this.sharedCreateFeatures(featureBuilder, layerData, mapContext, xSpace, ySpace, minX, minY);
    }

    private double calculateFirstLine(ReferencedEnvelope bounds, GridParam layerData, int ordinal) {
        double spaceFromOrigin = bounds.getMinimum(ordinal) - layerData.origin[ordinal];
        double linesBetweenOriginAndMap = Math.ceil(spaceFromOrigin / layerData.spacing[ordinal]);
        return linesBetweenOriginAndMap * layerData.spacing[ordinal] + layerData.origin[ordinal];
    }

    private DefaultFeatureCollection sharedCreateFeatures(SimpleFeatureBuilder featureBuilder, GridParam layerData, MapfishMapContext mapContext, double xSpace, double ySpace, double minX, double minY) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        String unit = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getUnit().toString();
        AxisDirection direction = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection();
        int numDimensions = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        double pointSpacing = bounds.getSpan(1) / (double)layerData.pointsInLine;
        int i = 0;
        for (double x = minX; x < bounds.getMaxX(); x += xSpace) {
            SimpleFeature feature = this.createFeature(mapContext, featureBuilder, geometryFactory, layerData, unit, direction, numDimensions, pointSpacing, x, bounds.getMinimum(1), ++i, 1);
            features.add(feature);
        }
        pointSpacing = bounds.getSpan(0) / (double)layerData.pointsInLine;
        int j = 0;
        for (double y = minY; y < bounds.getMaxY(); y += ySpace) {
            SimpleFeature feature = this.createFeature(mapContext, featureBuilder, geometryFactory, layerData, unit, direction, numDimensions, pointSpacing, bounds.getMinimum(0), y, ++j, 0);
            features.add(feature);
        }
        return features;
    }

    private SimpleFeature createFeature(MapfishMapContext mapContext, SimpleFeatureBuilder featureBuilder, GeometryFactory geometryFactory, GridParam layerData, String unit, AxisDirection direction, int numDimensions, double spacing, double x, double y, int i, int ordinate) {
        featureBuilder.reset();
        int numPoints = layerData.pointsInLine + 1;
        LinearCoordinateSequence coordinateSequence = new LinearCoordinateSequence().setDimension(numDimensions).setOrigin(x, y).setVariableAxis(ordinate).setNumPoints(numPoints).setSpacing(spacing).setOrdinate0AxisDirection(direction);
        LineString geom = geometryFactory.createLineString((CoordinateSequence)coordinateSequence);
        featureBuilder.add((Object)geom);
        featureBuilder.add((Object)this.createLabel(ordinate == 1 ? x : y, unit));
        int indentAmount = (int)(mapContext.getDPI() / 8.0);
        if (ordinate == 0) {
            featureBuilder.add((Object)0);
            featureBuilder.add((Object)(-(mapContext.getMapSize().width / 2) + indentAmount));
            featureBuilder.add((Object)0);
        } else {
            featureBuilder.add((Object)0);
            featureBuilder.add((Object)0);
            featureBuilder.add((Object)(-(mapContext.getMapSize().height / 2) + indentAmount));
        }
        return featureBuilder.buildFeature("grid." + (ordinate == 1 ? (char)'x' : 'y') + "." + i);
    }

    private String createLabel(double x, String unit) {
        double zero = 1.0E-9;
        int maxBeforeNoDecimals = 1000000;
        double minBeforeScientific = 1.0E-4;
        int maxWithDecimals = 1000;
        if (Math.abs(x - (double)Math.round(x)) < 1.0E-9) {
            return String.format("%d %s", Math.round(x), unit);
        }
        if (x > 1000000.0 || x < 1.0E-4) {
            return String.format("%1.0f %s", x, unit);
        }
        if (x < 1000.0) {
            return String.format("%f1.2 %s", x, unit);
        }
        if (x > 1.0E-4) {
            return String.format("%1.4f %s", x, unit);
        }
        return String.format("%e %s", x, unit);
    }
}

