/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.SLDTransformer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.StyleParserPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;

public final class StyleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(StyleParser.class);
    @Autowired
    private List<StyleParserPlugin> plugins = Lists.newArrayList();

    public Optional<? extends Style> loadStyle(Configuration configuration, @Nonnull ClientHttpRequestFactory clientHttpRequestFactory, String styleString, MapfishMapContext mapContext) {
        if (styleString != null) {
            for (StyleParserPlugin plugin : this.plugins) {
                try {
                    Optional<Style> style = plugin.parseStyle(configuration, clientHttpRequestFactory, styleString, mapContext);
                    if (!style.isPresent()) continue;
                    if (LOGGER.isDebugEnabled()) {
                        try {
                            SLDTransformer transformer = new SLDTransformer();
                            StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory();
                            UserLayer userLayer = styleFactory.createUserLayer();
                            userLayer.addUserStyle((Style)style.get());
                            StyledLayerDescriptor sld = styleFactory.createStyledLayerDescriptor();
                            sld.addStyledLayer((StyledLayer)userLayer);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Loaded style from: \n\n '" + styleString + "': \n\n" + transformer.transform((Object)sld));
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("Loaded style from: \n\n '" + styleString + "' \n\n<Unable to transform it to xml>: " + e, (Throwable)e);
                        }
                    }
                    return style;
                }
                catch (Throwable t) {
                    throw ExceptionUtils.getRuntimeException(t);
                }
            }
        }
        return Optional.absent();
    }
}

