/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.mapfish.print.output.AbstractJasperReportOutputFormat;
import org.mapfish.print.output.OutputFormat;

public final class JasperReportImageOutputFormat
extends AbstractJasperReportOutputFormat
implements OutputFormat {
    private int imageType = 2;
    private String fileSuffix;

    @Override
    public String getContentType() {
        return "image/" + this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    @Override
    public String getFileSuffix() {
        return this.fileSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExport(OutputStream outputStream, AbstractJasperReportOutputFormat.Print print) throws JRException, IOException {
        JasperPrint jasperPrint = print.print;
        int numPages = jasperPrint.getPages().size();
        float dpiRatio = (float)(print.dpi / print.requestorDpi);
        int pageHeightOnImage = (int)((float)(jasperPrint.getPageHeight() + 1) * dpiRatio);
        int pageWidthOnImage = (int)((float)jasperPrint.getPageWidth() * dpiRatio);
        BufferedImage reportImage = new BufferedImage(pageWidthOnImage, numPages * pageHeightOnImage, this.imageType);
        Graphics2D graphics2D = reportImage.createGraphics();
        try {
            JasperPrintManager printManager = JasperPrintManager.getInstance((JasperReportsContext)print.context);
            for (int pageIndex = 0; pageIndex < numPages; ++pageIndex) {
                Image pageImage = printManager.printToImage(jasperPrint, pageIndex, dpiRatio);
                graphics2D.drawImage(pageImage, 0, pageHeightOnImage * pageIndex, null);
                graphics2D.setColor(Color.black);
                graphics2D.drawLine(0, pageHeightOnImage, pageWidthOnImage, pageHeightOnImage);
            }
        }
        finally {
            graphics2D.dispose();
        }
        ImageIO.write((RenderedImage)reportImage, this.getFileSuffix(), outputStream);
    }

    public void setImageType(int imageType) {
        this.imageType = imageType;
    }
}

