/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.OverviewMapAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.geotools.FeatureLayer;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.InternalValue;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.map.CreateMapProcessor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateOverviewMapProcessor
extends AbstractProcessor<Input, Output> {
    @Autowired
    private CreateMapProcessor mapProcessor;
    @Autowired
    private FeatureLayer.Plugin featureLayerParser;

    public CreateOverviewMapProcessor() {
        super(Output.class);
    }

    @Override
    public final Input createInputParameter() {
        return new Input();
    }

    @Override
    public final Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        CreateMapProcessor.Input mapProcessorValues = this.mapProcessor.createInputParameter();
        mapProcessorValues.clientHttpRequestFactory = values.clientHttpRequestFactory;
        mapProcessorValues.tempTaskDirectory = values.tempTaskDirectory;
        MapAttribute.OverriddenMapAttributeValues mapParams = values.map.getWithOverrides(values.overviewMap);
        mapProcessorValues.map = mapParams;
        MapBounds boundsOfOriginalMap = mapParams.getOriginalBounds();
        this.setOriginalMapExtentLayer(boundsOfOriginalMap, values, mapParams);
        this.setOverviewMapBounds(mapParams, boundsOfOriginalMap, values);
        CreateMapProcessor.Output output = this.mapProcessor.execute(mapProcessorValues, context);
        return new Output(output.layerGraphics, output.mapSubReport);
    }

    private void setOriginalMapExtentLayer(MapBounds originalBounds, Input values, MapAttribute.OverriddenMapAttributeValues mapParams) throws IOException {
        Rectangle originalPaintArea = new Rectangle(values.map.getMapSize());
        MapBounds adjustedBounds = CreateMapProcessor.adjustBoundsToScaleAndMapSize(values.map, values.map.getDpi(), originalPaintArea, originalBounds);
        ReferencedEnvelope originalEnvelope = adjustedBounds.toReferencedEnvelope(originalPaintArea, values.map.getDpi());
        Polygon mapExtent = JTS.toGeometry((ReferencedEnvelope)originalEnvelope);
        if (values.map.getRotation() != 0.0) {
            mapExtent = this.rotateExtent((Geometry)mapExtent, values.map.getRotation(), originalEnvelope);
        }
        FeatureLayer layer = this.createOrignalMapExtentLayer((Geometry)mapExtent, mapParams, values.overviewMap.getStyle(), originalEnvelope.getCoordinateReferenceSystem());
        mapParams.setMapExtentLayer(layer);
    }

    private Geometry rotateExtent(Geometry mapExtent, double rotation, ReferencedEnvelope originalEnvelope) {
        Coordinate center = originalEnvelope.centre();
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(rotation), center.x, center.y);
        AffineTransform2D mathTransform = new AffineTransform2D(affineTransform);
        try {
            return JTS.transform((Geometry)mapExtent, (MathTransform)mathTransform);
        }
        catch (TransformException e) {
            throw new RuntimeException("Failed to rotate map extent", e);
        }
    }

    private FeatureLayer createOrignalMapExtentLayer(Geometry mapExtent, MapAttribute.OverriddenMapAttributeValues mapParams, String style, CoordinateReferenceSystem crs) throws IOException {
        FeatureLayer.FeatureLayerParam layerParams = new FeatureLayer.FeatureLayerParam();
        layerParams.style = style;
        layerParams.defaultStyle = "overview-map";
        layerParams.renderAsSvg = null;
        layerParams.features = this.wrapIntoFeatureCollection(mapExtent, crs);
        return this.featureLayerParser.parse(mapParams.getTemplate(), layerParams);
    }

    private DefaultFeatureCollection wrapIntoFeatureCollection(Geometry mapExtent, CoordinateReferenceSystem crs) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("overview-map");
        typeBuilder.setCRS(crs);
        typeBuilder.add("geom", Polygon.class);
        SimpleFeatureType type = typeBuilder.buildFeatureType();
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        features.add(SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{mapExtent}, null));
        return features;
    }

    private void setOverviewMapBounds(MapAttribute.OverriddenMapAttributeValues mapParams, MapBounds originalBounds, Input values) {
        MapBounds overviewMapBounds = mapParams.getCustomBounds() != null ? mapParams.getCustomBounds() : originalBounds.zoomOut(values.overviewMap.getZoomFactor());
        overviewMapBounds = overviewMapBounds.adjustedEnvelope(new Rectangle(values.overviewMap.getMapSize()));
        mapParams.setZoomedOutBounds(overviewMapBounds);
    }

    @Override
    protected final void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        this.mapProcessor.extraValidation(validationErrors, configuration);
    }

    public static final class Output {
        @InternalValue
        public final List<URI> layerGraphics;
        public final String overviewMapSubReport;

        private Output(List<URI> layerGraphics, String overviewMapSubReport) {
            this.layerGraphics = layerGraphics;
            this.overviewMapSubReport = overviewMapSubReport;
        }
    }

    public static final class Input
    extends CreateMapProcessor.Input {
        public OverviewMapAttribute.OverviewMapAttributeValues overviewMap;
    }
}

