/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class VersionInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionInfo.class);
    private static final String MAPFISH_PRINT_VERSION = "Mapfish-Print-Version";
    private static final String GIT_VERSION = "Git-Revision";
    @Nullable
    private Attributes attrs;
    @Autowired
    private ServletContext servletContext;

    @PostConstruct
    public final void init() {
        this.attrs = this.getAttributes();
        LOGGER.warn("Starting print version {} ({})", (Object)this.getVersion(), (Object)this.getGitHash());
    }

    public final String getVersion() {
        return this.getValue(MAPFISH_PRINT_VERSION);
    }

    public final String getGitHash() {
        return this.getValue(GIT_VERSION);
    }

    private String getValue(String name) {
        if (this.attrs != null) {
            String value = this.attrs.getValue(name);
            return value != null ? value : "?";
        }
        return "?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getAttributes() {
        block7: {
            Attributes attributes;
            if (this.servletContext == null) {
                return null;
            }
            String path = this.servletContext.getRealPath("/META-INF/MANIFEST.MF");
            if (path == null) break block7;
            FileInputStream stream = new FileInputStream(path);
            try {
                attributes = new Manifest(stream).getMainAttributes();
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    LOGGER.warn("Cannot find servlet manifest");
                    break block7;
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot read servlet manifest", (Throwable)e);
                }
            }
            ((InputStream)stream).close();
            return attributes;
        }
        return null;
    }
}

