/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.jasper.TableColumnConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class HttpImageResolver
implements TableColumnConverter<BufferedImage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpImageResolver.class);
    private static final int IMAGE_SIZE = 48;
    private Pattern urlExtractor = Pattern.compile("(.*)");
    private int urlGroup = 1;
    private BufferedImage defaultImage = new BufferedImage(48, 48, 6);

    public void setUrlExtractor(String pattern) {
        this.urlExtractor = Pattern.compile(pattern);
    }

    public void setUrlGroup(int urlGroup) {
        this.urlGroup = urlGroup;
    }

    @Override
    public BufferedImage resolve(MfClientHttpRequestFactory requestFactory, String text) throws URISyntaxException, IOException {
        Matcher urlMatcher = this.urlExtractor.matcher(text);
        if (urlMatcher.matches() && urlMatcher.group(this.urlGroup) != null) {
            String uriString = urlMatcher.group(this.urlGroup);
            try {
                URI url = new URI(uriString);
                ClientHttpRequest request = requestFactory.createRequest(url, HttpMethod.GET);
                ClientHttpResponse response = request.execute();
                if (response.getStatusCode() == HttpStatus.OK) {
                    try {
                        BufferedImage image = ImageIO.read(response.getBody());
                        if (image == null) {
                            LOGGER.warn("The URL: " + url + " is NOT an image format that can be decoded");
                            return this.defaultImage;
                        }
                        return image;
                    }
                    catch (IOException e) {
                        LOGGER.warn("Image loaded from '" + url + "'is not valid: " + e.getMessage());
                    }
                } else {
                    LOGGER.warn("Error loading the table row image: " + url + ".\nStatus Code: " + response.getStatusCode() + "\nStatus Text: " + response.getStatusText());
                }
            }
            catch (Throwable e) {
                LOGGER.warn("Error loading table row image: " + uriString, e);
            }
        }
        return this.defaultImage;
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.urlExtractor == null) {
            validationErrors.add(new ConfigurationException("No urlExtractor defined"));
        }
    }

    @Override
    public boolean canConvert(String text) {
        Matcher urlMatcher = this.urlExtractor.matcher(text);
        return urlMatcher.matches() && urlMatcher.group(this.urlGroup) != null;
    }
}

