/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.mapfish.print.attribute.ScalebarAttribute;
import org.mapfish.print.processor.map.scalebar.Label;
import org.mapfish.print.processor.map.scalebar.Orientation;
import org.mapfish.print.processor.map.scalebar.ScaleBarRenderSettings;

public abstract class ScalebarDrawer {
    private final Graphics2D graphics2d;
    private final ScaleBarRenderSettings settings;
    private final ScalebarAttribute.ScalebarAttributeValues params;

    public ScalebarDrawer(Graphics2D graphics2d, ScaleBarRenderSettings settings) {
        this.graphics2d = graphics2d;
        this.settings = settings;
        this.params = settings.getParams();
    }

    public final void draw() {
        AffineTransform transform = this.getAlignmentTransform();
        this.graphics2d.setTransform(transform);
        this.graphics2d.setColor(this.params.getBackgroundColor());
        this.graphics2d.fillRect(0, 0, this.settings.getSize().width, this.settings.getSize().height);
        this.graphics2d.setColor(this.params.getFontColor());
        this.drawLabels(transform, this.params.getOrientation(), this.params.getLabelRotation());
        AffineTransform lineTransform = new AffineTransform(transform);
        this.setLineTranslate(lineTransform);
        if (this.params.getOrientation() == Orientation.VERTICAL_LABELS_LEFT || this.params.getOrientation() == Orientation.VERTICAL_LABELS_RIGHT) {
            AffineTransform rotate = AffineTransform.getQuadrantRotateInstance(1);
            lineTransform.concatenate(rotate);
        }
        this.graphics2d.setTransform(lineTransform);
        this.graphics2d.setStroke(new BasicStroke(this.settings.getLineWidth()));
        this.graphics2d.setColor(this.params.getColor());
        this.drawBar();
    }

    private AffineTransform getAlignmentTransform() {
        int offsetY;
        int offsetX;
        switch (this.settings.getParams().getAlign()) {
            case LEFT: {
                offsetX = 0;
                break;
            }
            case RIGHT: {
                offsetX = this.settings.getMaxSize().width - this.settings.getSize().width;
                break;
            }
            default: {
                offsetX = (int)Math.floor((double)this.settings.getMaxSize().width / 2.0 - (double)this.settings.getSize().width / 2.0);
            }
        }
        switch (this.settings.getParams().getVerticalAlign()) {
            case TOP: {
                offsetY = 0;
                break;
            }
            case BOTTOM: {
                offsetY = this.settings.getMaxSize().height - this.settings.getSize().height;
                break;
            }
            default: {
                offsetY = (int)Math.floor((double)this.settings.getMaxSize().height / 2.0 - (double)this.settings.getSize().height / 2.0);
            }
        }
        return AffineTransform.getTranslateInstance(Math.round(offsetX), Math.round(offsetY));
    }

    private void setLineTranslate(AffineTransform lineTransform) {
        float y;
        float x;
        if (this.params.getOrientation() == Orientation.HORIZONTAL_LABELS_BELOW) {
            x = (float)this.settings.getPadding() + this.settings.getLeftLabelMargin();
            y = this.settings.getPadding() + this.settings.getBarSize();
        } else if (this.params.getOrientation() == Orientation.HORIZONTAL_LABELS_ABOVE) {
            x = (float)this.settings.getPadding() + this.settings.getLeftLabelMargin();
            y = (float)(this.settings.getPadding() + this.settings.getBarSize() + this.settings.getLabelDistance()) + Label.getRotatedHeight(this.settings.getMaxLabelSize(), this.params.getLabelRotation());
        } else if (this.params.getOrientation() == Orientation.VERTICAL_LABELS_LEFT) {
            x = (float)this.settings.getPadding() + Label.getRotatedWidth(this.settings.getMaxLabelSize(), this.params.getLabelRotation()) + (float)this.settings.getLabelDistance();
            y = (float)this.settings.getPadding() + this.settings.getTopLabelMargin();
        } else {
            x = this.settings.getPadding();
            y = (float)this.settings.getPadding() + this.settings.getTopLabelMargin();
        }
        lineTransform.translate(Math.round(x), Math.round(y));
    }

    private void setLabelTranslate(AffineTransform labelTransform) {
        float y;
        float x;
        if (this.params.getOrientation() == Orientation.HORIZONTAL_LABELS_BELOW) {
            x = (float)this.settings.getPadding() + this.settings.getLeftLabelMargin();
            y = this.settings.getPadding() + this.settings.getBarSize() + this.settings.getLabelDistance();
        } else if (this.params.getOrientation() == Orientation.HORIZONTAL_LABELS_ABOVE) {
            x = (float)this.settings.getPadding() + this.settings.getLeftLabelMargin();
            y = (float)this.settings.getPadding() + Label.getRotatedHeight(this.settings.getMaxLabelSize(), this.params.getLabelRotation());
        } else if (this.params.getOrientation() == Orientation.VERTICAL_LABELS_LEFT) {
            x = (float)this.settings.getPadding() + Label.getRotatedWidth(this.settings.getMaxLabelSize(), this.params.getLabelRotation());
            y = (float)this.settings.getPadding() + this.settings.getTopLabelMargin();
        } else {
            x = this.settings.getPadding() + this.settings.getBarSize() + this.settings.getLabelDistance();
            y = (float)this.settings.getPadding() + this.settings.getTopLabelMargin();
        }
        labelTransform.translate(Math.round(x), Math.round(y));
    }

    protected abstract void drawBar();

    private void drawLabels(AffineTransform transform, Orientation orientation, float labelRotation) {
        float prevMargin = orientation.isHorizontal() ? (float)this.settings.getMaxSize().width : (float)this.settings.getMaxSize().height;
        AffineTransform firstTickTransform = new AffineTransform(transform);
        this.setLabelTranslate(firstTickTransform);
        for (int i = this.settings.getLabels().size() - 1; i >= 0; --i) {
            float newMargin;
            boolean shouldSkipLabel;
            Label label = this.settings.getLabels().get(i);
            AffineTransform centerTransform = new AffineTransform(firstTickTransform);
            float halfRotatedWidth = label.getRotatedWidth(labelRotation) / 2.0f;
            float halfRotatedHeight = label.getRotatedHeight(labelRotation) / 2.0f;
            if (orientation.isHorizontal()) {
                centerTransform.concatenate(AffineTransform.getTranslateInstance(Math.round(label.getGraphicOffset()), Math.round(orientation == Orientation.HORIZONTAL_LABELS_BELOW ? halfRotatedHeight : -halfRotatedHeight)));
                shouldSkipLabel = label.getGraphicOffset() + halfRotatedWidth > prevMargin - 1.0f;
                newMargin = label.getGraphicOffset() - halfRotatedWidth;
            } else {
                centerTransform.concatenate(AffineTransform.getTranslateInstance(Math.round(orientation == Orientation.VERTICAL_LABELS_RIGHT ? halfRotatedWidth : -halfRotatedWidth), Math.round(label.getGraphicOffset())));
                shouldSkipLabel = label.getGraphicOffset() + halfRotatedHeight > prevMargin - 1.0f;
                newMargin = label.getGraphicOffset() - halfRotatedHeight;
            }
            if ((double)labelRotation != 0.0) {
                centerTransform.concatenate(AffineTransform.getRotateInstance(Math.toRadians(labelRotation)));
            }
            if (shouldSkipLabel) continue;
            this.graphics2d.setTransform(centerTransform);
            label.getLabelLayout().draw(this.graphics2d, (float)Math.floor(-label.getWidth() / 2.0f), (float)Math.floor(label.getHeight() / 2.0f));
            prevMargin = newMargin;
        }
    }

    public final Graphics2D getGraphics2d() {
        return this.graphics2d;
    }

    public final ScaleBarRenderSettings getSettings() {
        return this.settings;
    }

    public final ScalebarAttribute.ScalebarAttributeValues getParams() {
        return this.params;
    }
}

