/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;

public class Label {
    private final float graphicOffset;
    private final float width;
    private final float height;
    private final TextLayout labelLayout;

    public Label(float graphicOffset, TextLayout labelLayout, Graphics2D graphics2D) {
        this.graphicOffset = graphicOffset;
        this.labelLayout = labelLayout;
        Rectangle bounds = this.labelLayout.getPixelBounds(graphics2D.getFontRenderContext(), 0.0f, 0.0f);
        this.width = (float)bounds.getWidth();
        this.height = (float)bounds.getHeight();
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getGraphicOffset() {
        return this.graphicOffset;
    }

    public final TextLayout getLabelLayout() {
        return this.labelLayout;
    }

    public float getRotatedWidth(float angle) {
        return Label.getRotatedWidth(this.width, this.height, angle);
    }

    public float getRotatedHeight(float angle) {
        return Label.getRotatedHeight(this.width, this.height, angle);
    }

    private static float getRotatedWidth(float width, float height, float angle) {
        return (float)(Math.abs((double)width * Math.cos(angle)) + Math.abs((double)height * Math.sin(angle)));
    }

    private static float getRotatedHeight(float width, float height, float angle) {
        return (float)(Math.abs((double)height * Math.cos(angle)) + Math.abs((double)width * Math.sin(angle)));
    }

    public static float getRotatedHeight(Dimension dimension, float angle) {
        return Label.getRotatedHeight(dimension.width, dimension.height, angle);
    }

    public static float getRotatedWidth(Dimension dimension, float angle) {
        return Label.getRotatedWidth(dimension.width, dimension.height, angle);
    }
}

