/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGraphics2D;
import org.geotools.referencing.GeodeticCalculator;
import org.mapfish.print.attribute.ScalebarAttribute;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;
import org.mapfish.print.processor.map.CreateMapProcessor;
import org.mapfish.print.processor.map.scalebar.Label;
import org.mapfish.print.processor.map.scalebar.ScaleBarRenderSettings;
import org.mapfish.print.processor.map.scalebar.ScalebarDrawer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalebarGraphic {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScalebarGraphic.class);
    private static final int MAX_NUMBER_LAYOUTING_TRIES = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final URI render(MapfishMapContext mapContext, ScalebarAttribute.ScalebarAttributeValues scalebarParams, File tempFolder, Template template) throws IOException, ParserConfigurationException {
        double dpi = mapContext.getDPI();
        double dpiRatio = dpi / 72.0;
        Rectangle paintArea = new Rectangle(mapContext.getMapSize());
        MapBounds bounds = mapContext.getBounds();
        DistanceUnit mapUnit = this.getUnit(bounds);
        Scale scale = bounds.getScale(paintArea, 72.0);
        double scaleDenominator = scale.getDenominator(scalebarParams.geodetic, bounds.getProjection(), dpi, bounds.getCenter());
        DistanceUnit scaleUnit = scalebarParams.getUnit();
        if (scaleUnit == null) {
            scaleUnit = mapUnit;
        }
        int maxWidthInPixelAdjusted = (int)((double)scalebarParams.getSize().width * dpiRatio);
        int maxHeightInPixelAdjusted = (int)((double)scalebarParams.getSize().height * dpiRatio);
        int maxLengthInPixelAdjusted = scalebarParams.getOrientation().isHorizontal() ? maxWidthInPixelAdjusted : maxHeightInPixelAdjusted;
        double maxIntervalLengthInWorldUnits = DistanceUnit.PX.convertTo(maxLengthInPixelAdjusted, scaleUnit) * scaleDenominator / (double)scalebarParams.intervals.intValue();
        double niceIntervalLengthInWorldUnits = ScalebarGraphic.getNearestNiceValue(maxIntervalLengthInWorldUnits, scaleUnit, scalebarParams.lockUnits);
        ScaleBarRenderSettings settings = new ScaleBarRenderSettings();
        settings.setParams(scalebarParams);
        settings.setMaxSize(new Dimension(maxWidthInPixelAdjusted, maxHeightInPixelAdjusted));
        settings.setDpiRatio(dpiRatio);
        settings.setPadding(ScalebarGraphic.getPadding(settings));
        File path = null;
        if (template.getConfiguration().renderAsSvg(scalebarParams.renderAsSvg)) {
            SVGGraphics2D graphics2D = CreateMapProcessor.getSvgGraphics(new Dimension(maxWidthInPixelAdjusted, maxHeightInPixelAdjusted));
            try {
                ScalebarGraphic.tryLayout((Graphics2D)graphics2D, scaleUnit, scaleDenominator, niceIntervalLengthInWorldUnits, settings, 0);
                path = File.createTempFile("scalebar-graphic-", ".svg", tempFolder);
                CreateMapProcessor.saveSvgFile(graphics2D, path);
            }
            finally {
                graphics2D.dispose();
            }
        }
        BufferedImage bufferedImage = new BufferedImage(maxWidthInPixelAdjusted, maxHeightInPixelAdjusted, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            ScalebarGraphic.tryLayout(graphics2D, scaleUnit, scaleDenominator, niceIntervalLengthInWorldUnits, settings, 0);
            path = File.createTempFile("scalebar-graphic-", ".tiff", tempFolder);
            ImageIO.write((RenderedImage)bufferedImage, "tiff", path);
        }
        finally {
            graphics2D.dispose();
        }
        return path.toURI();
    }

    private DistanceUnit getUnit(MapBounds bounds) {
        GeodeticCalculator calculator = new GeodeticCalculator(bounds.getProjection());
        return DistanceUnit.fromString(calculator.getEllipsoid().getAxisUnit().toString());
    }

    private static void tryLayout(Graphics2D graphics2D, DistanceUnit scaleUnit, double scaleDenominator, double intervalLengthInWorldUnits, ScaleBarRenderSettings settings, int tryNumber) {
        float bottomLabelMargin;
        float topLabelMargin;
        float rightLabelMargin;
        float leftLabelMargin;
        if (tryNumber > 3) {
            LOGGER.error("layouting the scalebar failed (unit: " + scaleUnit.toString() + ", scale: " + scaleDenominator + ")");
            return;
        }
        ScalebarAttribute.ScalebarAttributeValues scalebarParams = settings.getParams();
        DistanceUnit intervalUnit = ScalebarGraphic.bestUnit(scaleUnit, intervalLengthInWorldUnits, scalebarParams.lockUnits);
        float intervalLengthInPixels = (float)scaleUnit.convertTo(intervalLengthInWorldUnits / scaleDenominator, DistanceUnit.PX);
        ArrayList<Label> labels = new ArrayList<Label>(scalebarParams.intervals + 1);
        Font font = new Font(scalebarParams.font, 0, ScalebarGraphic.getFontSize(settings));
        FontRenderContext frc = new FontRenderContext(null, true, true);
        if (scalebarParams.intervals > 1 || scalebarParams.subIntervals.booleanValue()) {
            for (int i = 0; i <= scalebarParams.intervals; ++i) {
                String labelText = ScalebarGraphic.createLabelText(scaleUnit, intervalLengthInWorldUnits * (double)i, intervalUnit);
                if (i == scalebarParams.intervals) {
                    labelText = labelText + (Object)((Object)intervalUnit);
                }
                TextLayout labelLayout = new TextLayout(labelText, font, frc);
                labels.add(new Label(intervalLengthInPixels * (float)i, labelLayout, graphics2D));
            }
            leftLabelMargin = ((Label)labels.get(0)).getRotatedWidth(scalebarParams.getLabelRotation()) / 2.0f;
            rightLabelMargin = ((Label)labels.get(labels.size() - 1)).getRotatedWidth(scalebarParams.getLabelRotation()) / 2.0f;
            topLabelMargin = ((Label)labels.get(0)).getRotatedHeight(scalebarParams.getLabelRotation()) / 2.0f;
            bottomLabelMargin = ((Label)labels.get(labels.size() - 1)).getRotatedHeight(scalebarParams.getLabelRotation()) / 2.0f;
        } else {
            String labelText = ScalebarGraphic.createLabelText(scaleUnit, intervalLengthInWorldUnits, intervalUnit) + (Object)((Object)intervalUnit);
            TextLayout labelLayout = new TextLayout(labelText, font, frc);
            Label label = new Label(intervalLengthInPixels / 2.0f, labelLayout, graphics2D);
            labels.add(label);
            rightLabelMargin = 0.0f;
            leftLabelMargin = 0.0f;
            topLabelMargin = 0.0f;
            bottomLabelMargin = 0.0f;
        }
        if (ScalebarGraphic.fitsAvailableSpace(scalebarParams, intervalLengthInPixels, leftLabelMargin, rightLabelMargin, topLabelMargin, bottomLabelMargin, settings)) {
            settings.setLabels(labels);
            settings.setScaleUnit(scaleUnit);
            settings.setIntervalLengthInPixels(intervalLengthInPixels);
            settings.setIntervalLengthInWorldUnits(intervalLengthInWorldUnits);
            settings.setIntervalUnit(intervalUnit);
            settings.setLeftLabelMargin(leftLabelMargin);
            settings.setRightLabelMargin(rightLabelMargin);
            settings.setTopLabelMargin(topLabelMargin);
            settings.setBottomLabelMargin(bottomLabelMargin);
            ScalebarGraphic.doLayout(graphics2D, scalebarParams, settings);
        } else {
            double nextIntervalDistance = ScalebarGraphic.getNearestNiceValue(intervalLengthInWorldUnits * 0.9, scaleUnit, scalebarParams.lockUnits);
            ScalebarGraphic.tryLayout(graphics2D, scaleUnit, scaleDenominator, nextIntervalDistance, settings, tryNumber + 1);
        }
    }

    private static boolean fitsAvailableSpace(ScalebarAttribute.ScalebarAttributeValues scalebarParams, float intervalWidthInPixels, float leftLabelMargin, float rightLabelMargin, float topLabelMargin, float bottomLabelMargin, ScaleBarRenderSettings settings) {
        if (scalebarParams.getOrientation().isHorizontal()) {
            return (float)scalebarParams.intervals.intValue() * intervalWidthInPixels + leftLabelMargin + rightLabelMargin + (float)(2 * settings.getPadding()) <= (float)settings.getMaxSize().width;
        }
        return (float)scalebarParams.intervals.intValue() * intervalWidthInPixels + topLabelMargin + bottomLabelMargin + (float)(2 * settings.getPadding()) <= (float)settings.getMaxSize().height;
    }

    private static void doLayout(Graphics2D graphics2d, ScalebarAttribute.ScalebarAttributeValues scalebarParams, ScaleBarRenderSettings settings) {
        Dimension maxLabelSize = ScalebarGraphic.getMaxLabelSize(settings);
        int numSubIntervals = 1;
        if (scalebarParams.subIntervals.booleanValue()) {
            numSubIntervals = ScalebarGraphic.getNbSubIntervals(settings.getScaleUnit(), settings.getIntervalLengthInWorldUnits(), settings.getIntervalUnit());
        }
        settings.setBarSize(ScalebarGraphic.getBarSize(settings));
        settings.setLabelDistance(ScalebarGraphic.getLabelDistance(settings));
        settings.setLineWidth(ScalebarGraphic.getLineWidth(settings));
        settings.setSize(ScalebarGraphic.getSize(scalebarParams, settings, maxLabelSize));
        settings.setMaxLabelSize(maxLabelSize);
        settings.setNumSubIntervals(numSubIntervals);
        ScalebarDrawer drawer = scalebarParams.getType().createDrawer(graphics2d, settings);
        drawer.draw();
    }

    @VisibleForTesting
    protected static Dimension getSize(ScalebarAttribute.ScalebarAttributeValues scalebarParams, ScaleBarRenderSettings settings, Dimension maxLabelSize) {
        float height;
        float width;
        if (scalebarParams.getOrientation().isHorizontal()) {
            width = (float)(2 * settings.getPadding()) + settings.getIntervalLengthInPixels() * (float)scalebarParams.intervals.intValue() + settings.getLeftLabelMargin() + settings.getRightLabelMargin();
            height = (float)(2 * settings.getPadding() + settings.getBarSize() + settings.getLabelDistance()) + Label.getRotatedHeight(maxLabelSize, scalebarParams.getLabelRotation());
        } else {
            width = (float)(2 * settings.getPadding() + settings.getLabelDistance() + settings.getBarSize()) + Label.getRotatedWidth(maxLabelSize, scalebarParams.getLabelRotation());
            height = (float)(2 * settings.getPadding()) + settings.getTopLabelMargin() + settings.getIntervalLengthInPixels() * (float)scalebarParams.intervals.intValue() + settings.getBottomLabelMargin();
        }
        return new Dimension((int)Math.ceil(width), (int)Math.ceil(height));
    }

    @VisibleForTesting
    protected static Dimension getMaxLabelSize(ScaleBarRenderSettings settings) {
        float maxLabelHeight = 0.0f;
        float maxLabelWidth = 0.0f;
        for (Label label : settings.getLabels()) {
            maxLabelHeight = Math.max(maxLabelHeight, label.getHeight());
            maxLabelWidth = Math.max(maxLabelWidth, label.getWidth());
        }
        return new Dimension((int)Math.ceil(maxLabelWidth), (int)Math.ceil(maxLabelHeight));
    }

    @VisibleForTesting
    protected static String createLabelText(DistanceUnit scaleUnit, double value, DistanceUnit intervalUnit) {
        double scaledValue = scaleUnit.convertTo(value, intervalUnit);
        String decimals = Double.toString(scaledValue = (double)(Math.round(scaledValue * 10000.0) / 10000L)).split("\\.")[1];
        if (Double.valueOf(decimals) == 0.0) {
            return Long.toString(Math.round(scaledValue));
        }
        return Double.toString(scaledValue);
    }

    private static DistanceUnit bestUnit(DistanceUnit scaleUnit, double intervalDistance, boolean lockUnits) {
        if (lockUnits) {
            return scaleUnit;
        }
        return DistanceUnit.getBestUnit(intervalDistance, scaleUnit);
    }

    @VisibleForTesting
    protected static double getNearestNiceValue(double value, DistanceUnit scaleUnit, boolean lockUnits) {
        int digits;
        double pow10;
        DistanceUnit bestUnit = ScalebarGraphic.bestUnit(scaleUnit, value, lockUnits);
        double factor = scaleUnit.convertTo(1.0, bestUnit);
        double firstChar = value * factor / (pow10 = Math.pow(10.0, digits = (int)Math.floor(Math.log(value * factor) / Math.log(10.0))));
        int barLen = firstChar >= 10.0 ? 10 : (firstChar >= 5.0 ? 5 : (firstChar >= 2.0 ? 2 : 1));
        return (double)barLen * pow10 / factor;
    }

    private static int getNbSubIntervals(DistanceUnit scaleUnit, double intervalDistance, DistanceUnit intervalUnit) {
        double value = scaleUnit.convertTo(intervalDistance, intervalUnit);
        int digits = (int)(Math.log(value) / Math.log(10.0));
        double pow10 = Math.pow(10.0, digits);
        int firstChar = (int)(value / pow10);
        switch (firstChar) {
            case 1: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 5;
            }
            case 10: {
                return 2;
            }
        }
        throw new RuntimeException("Invalid interval: " + value + (Object)((Object)intervalUnit) + " (" + firstChar + ")");
    }

    private static int getFontSize(ScaleBarRenderSettings settings) {
        return (int)Math.ceil((double)settings.getParams().fontSize.intValue() * settings.getDpiRatio());
    }

    private static int getLineWidth(ScaleBarRenderSettings settings) {
        if (settings.getParams().lineWidth != null) {
            return (int)Math.ceil((double)settings.getParams().lineWidth.intValue() * settings.getDpiRatio());
        }
        if (settings.getParams().getOrientation().isHorizontal()) {
            return settings.getMaxSize().width / 150;
        }
        return settings.getMaxSize().height / 150;
    }

    @VisibleForTesting
    protected static int getBarSize(ScaleBarRenderSettings settings) {
        if (settings.getParams().barSize != null) {
            return (int)Math.ceil((double)settings.getParams().barSize.intValue() * settings.getDpiRatio());
        }
        if (settings.getParams().getOrientation().isHorizontal()) {
            return settings.getMaxSize().height / 4;
        }
        return settings.getMaxSize().width / 4;
    }

    @VisibleForTesting
    protected static int getLabelDistance(ScaleBarRenderSettings settings) {
        if (settings.getParams().labelDistance != null) {
            return (int)Math.ceil((double)settings.getParams().labelDistance.intValue() * settings.getDpiRatio());
        }
        if (settings.getParams().getOrientation().isHorizontal()) {
            return settings.getMaxSize().width / 40;
        }
        return settings.getMaxSize().height / 40;
    }

    private static int getPadding(ScaleBarRenderSettings settings) {
        if (settings.getParams().padding != null) {
            return (int)Math.ceil((double)settings.getParams().padding.intValue() * settings.getDpiRatio());
        }
        if (settings.getParams().getOrientation().isHorizontal()) {
            return settings.getMaxSize().width / 40;
        }
        return settings.getMaxSize().height / 40;
    }
}

