/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl.hibernate;

import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.mapfish.print.servlet.job.PrintJobStatus;
import org.mapfish.print.servlet.job.impl.hibernate.PrintJobResultExtImpl;
import org.mapfish.print.servlet.job.impl.hibernate.PrintJobStatusExtImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class PrintJobDao {
    @Autowired
    private SessionFactory sf;

    @PostConstruct
    public final void init() {
        this.sf.openSession();
    }

    public final Session getSession() {
        return this.sf.getCurrentSession();
    }

    public final void save(PrintJobStatusExtImpl entry) {
        this.getSession().merge((Object)entry);
        this.getSession().flush();
        this.getSession().evict((Object)entry);
    }

    public final PrintJobStatusExtImpl get(String id) {
        PrintJobStatusExtImpl result = this.get(id, false);
        this.getSession().evict((Object)result);
        return result;
    }

    public final PrintJobStatusExtImpl get(String id, boolean lock) {
        Criteria c = this.getSession().createCriteria(PrintJobStatusExtImpl.class);
        c.add(Restrictions.idEq((Object)id));
        if (lock) {
            c.setLockMode("pj", LockMode.PESSIMISTIC_READ);
            c.setFetchMode("result", FetchMode.SELECT);
        } else {
            c.setReadOnly(true);
        }
        return (PrintJobStatusExtImpl)c.uniqueResult();
    }

    public final Object getValue(String id, String property) {
        Criteria c = this.getSession().createCriteria(PrintJobStatusExtImpl.class);
        c.add(Restrictions.idEq((Object)id));
        c.setProjection((Projection)Projections.property((String)property));
        return c.uniqueResult();
    }

    public final int count(PrintJobStatus.Status ... statuses) {
        Criteria c = this.getSession().createCriteria(PrintJobStatusExtImpl.class);
        if (statuses.length > 0) {
            c.add(Restrictions.in((String)"status", (Object[])statuses));
        }
        c.setProjection(Projections.rowCount());
        return ((Number)c.uniqueResult()).intValue();
    }

    public final List<PrintJobStatusExtImpl> get(PrintJobStatus.Status ... statuses) {
        Criteria c = this.getSession().createCriteria(PrintJobStatusExtImpl.class);
        if (statuses.length > 0) {
            c.add(Restrictions.in((String)"status", (Object[])statuses));
        }
        return c.list();
    }

    public final long getTotalTimeSpentPrinting() {
        Criteria c = this.getSession().createCriteria(PrintJobStatusExtImpl.class);
        c.add(Restrictions.isNotNull((String)"completionTime"));
        c.setProjection(Projections.sqlProjection((String)"sum(completionTime - startTime) as totalTime", (String[])new String[]{"totalTime"}, (Type[])new Type[]{LongType.INSTANCE}));
        Number result = (Number)c.uniqueResult();
        return result == null ? 0L : result.longValue();
    }

    public final void cancelOld(long starttimeThreshold, long checkTimeThreshold, String message) {
        Query query = this.getSession().createQuery("update PrintJobStatusExtImpl pj set status=:newstatus, error=:msg where pj.status = :oldstatus and (startTime < :starttimethreshold or lastCheckTime < :checktimethreshold)");
        query.setParameter("oldstatus", (Object)PrintJobStatus.Status.WAITING);
        query.setParameter("newstatus", (Object)PrintJobStatus.Status.CANCELLED);
        query.setParameter("msg", (Object)message);
        query.setParameter("starttimethreshold", (Object)starttimeThreshold);
        query.setParameter("checktimethreshold", (Object)checkTimeThreshold);
        query.executeUpdate();
    }

    public final void updateLastCheckTime(String id, long lastCheckTime) {
        Query query = this.getSession().createQuery("update PrintJobStatusExtImpl pj set lastCheckTime=:lastCheckTime where pj.referenceId = :id");
        query.setParameter("id", (Object)id);
        query.setParameter("lastCheckTime", (Object)lastCheckTime);
        query.executeUpdate();
    }

    public final void deleteOld(long checkTimeThreshold) {
        Query query = this.getSession().createQuery("delete from PrintJobStatusExtImpl where lastCheckTime < :checktimethreshold)");
        query.setParameter("checktimethreshold", (Object)checkTimeThreshold);
        query.executeUpdate();
    }

    public final List<PrintJobStatusExtImpl> poll(int size) {
        Query query = this.getSession().createQuery("from PrintJobStatusExtImpl pj where status = :status order by startTime");
        query.setParameter("status", (Object)PrintJobStatus.Status.WAITING);
        query.setMaxResults(size);
        query.setLockMode("pj", LockMode.UPGRADE_NOWAIT);
        return query.list();
    }

    public final PrintJobResultExtImpl getResult(URI reportURI) {
        Criteria c = this.getSession().createCriteria(PrintJobResultExtImpl.class);
        c.add(Restrictions.idEq((Object)reportURI.toString()));
        return (PrintJobResultExtImpl)c.uniqueResult();
    }
}

