/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.mapfish.print.map.geotools.grid.GridParam;

public abstract class GridLabelFormat {
    public static GridLabelFormat fromConfig(GridParam param) {
        if (param.labelFormat != null) {
            return new Simple(param.labelFormat);
        }
        if (param.valueFormat != null) {
            return new Detailed(param.valueFormat, param.unitFormat, param.formatDecimalSeparator, param.formatGroupingSeparator);
        }
        return null;
    }

    public abstract String format(double var1, String var3);

    public static class Detailed
    extends GridLabelFormat {
        private String valueFormat;
        private String unitFormat;
        private String formatDecimalSeparator;
        private String formatGroupingSeparator;

        public Detailed(String valueFormat, String unitFormat, String formatDecimalSeparator, String formatGroupingSeparator) {
            this.valueFormat = valueFormat;
            this.unitFormat = unitFormat == null ? " %s" : unitFormat;
            this.formatDecimalSeparator = formatDecimalSeparator;
            this.formatGroupingSeparator = formatGroupingSeparator;
        }

        @Override
        public final String format(double value, String unit) {
            DecimalFormat decimalFormat = null;
            if (this.formatDecimalSeparator != null || this.formatGroupingSeparator != null) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                if (this.formatDecimalSeparator != null) {
                    symbols.setDecimalSeparator(this.formatDecimalSeparator.charAt(0));
                }
                if (this.formatGroupingSeparator != null) {
                    symbols.setGroupingSeparator(this.formatGroupingSeparator.charAt(0));
                }
                decimalFormat = new DecimalFormat(this.valueFormat, symbols);
            } else {
                decimalFormat = new DecimalFormat(this.valueFormat);
            }
            return decimalFormat.format(value) + String.format(this.unitFormat, unit);
        }
    }

    public static class Simple
    extends GridLabelFormat {
        private String labelFormat = null;

        public Simple(String labelFormat) {
            this.labelFormat = labelFormat;
        }

        @Override
        public final String format(double value, String unit) {
            return String.format(this.labelFormat, value, unit);
        }
    }
}

