/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http.matcher;

import com.google.common.base.Optional;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.processor.http.matcher.AbstractMatcher;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HostMatcher
extends AbstractMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostMatcher.class);
    protected int port = -1;
    protected String pathRegex = null;

    @Override
    public final boolean matches(MatchInfo matchInfo) throws UnknownHostException, SocketException, MalformedURLException {
        Matcher matcher;
        Optional<Boolean> overridden = this.tryOverrideValidation(matchInfo);
        if (overridden.isPresent()) {
            return (Boolean)overridden.get();
        }
        int uriPort = matchInfo.getPort();
        if (uriPort != -1 && this.port > 0 && uriPort != this.port) {
            return false;
        }
        if (this.pathRegex != null && matchInfo.getPath() != MatchInfo.ANY_PATH && !(matcher = Pattern.compile(this.pathRegex).matcher(matchInfo.getPath())).matches()) {
            LOGGER.debug("pathRegex '{}' is not matching '{}'", (Object)this.pathRegex, (Object)matchInfo.getPath());
            return false;
        }
        return true;
    }

    protected abstract Optional<Boolean> tryOverrideValidation(MatchInfo var1) throws UnknownHostException, SocketException, MalformedURLException;

    public final void setPort(int port) {
        this.port = port;
    }

    public final void setPathRegex(String pathRegex) {
        this.pathRegex = pathRegex;
    }

    public abstract String toString();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pathRegex == null ? 0 : this.pathRegex.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostMatcher other = (HostMatcher)obj;
        if (this.pathRegex == null ? other.pathRegex != null : !this.pathRegex.equals(other.pathRegex)) {
            return false;
        }
        return this.port == other.port;
    }
}

