/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.output.Values;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.CustomDependencies;
import org.mapfish.print.processor.Processor;

@Beta
public final class MergeDataSourceProcessor
extends AbstractProcessor<In, Out>
implements CustomDependencies {
    private List<Source> sources = Lists.newArrayList();

    protected MergeDataSourceProcessor() {
        super(Out.class);
    }

    public void setSources(List<Source> sources) {
        this.sources = sources;
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration config) {
        if (this.sources == null || this.sources.isEmpty()) {
            validationErrors.add(new ConfigurationException(this.getClass().getSimpleName() + " needs to have at minimum a single source. Although logically it should have more"));
            return;
        }
        for (int i = 0; i < this.sources.size(); ++i) {
            Source source = this.sources.get(i);
            if (source.type == null) {
                validationErrors.add(new ConfigurationException("The " + MergeDataSourceProcessor.indexString(i) + " source in " + this.getClass().getSimpleName() + " needs to have a 'type' parameter defined."));
                continue;
            }
            source.type.validate(i, validationErrors, source);
        }
    }

    @Override
    @Nullable
    public In createInputParameter() {
        return new In();
    }

    @Override
    @Nullable
    public Out execute(In values, Processor.ExecutionContext context) throws Exception {
        ArrayList rows = Lists.newArrayList();
        for (Source source : this.sources) {
            source.type.add(rows, values.values, source);
        }
        JRMapCollectionDataSource mergedDataSource = new JRMapCollectionDataSource((Collection)rows);
        return new Out((JRDataSource)mergedDataSource);
    }

    @Override
    @Nonnull
    public Collection<String> getDependencies() {
        HashSet sourceKeys = Sets.newHashSet();
        for (Source source : this.sources) {
            source.type.addValuesKeys(source, sourceKeys);
        }
        return sourceKeys;
    }

    private static String indexString(int i) {
        switch (i + 1) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
        }
        return i + 1 + "th";
    }

    public static enum SourceType {
        SINGLE{

            @Override
            void add(List<Map<String, ?>> rows, Values values, Source source) {
                HashMap row = Maps.newHashMap();
                for (Map.Entry<String, String> entry : source.fields.entrySet()) {
                    Object object = values.getObject(entry.getKey(), Object.class);
                    row.put(entry.getValue(), object);
                }
                rows.add(row);
            }

            @Override
            void validate(int rowIndex, List<Throwable> validationErrors, Source source) {
                if (source.key != null) {
                    validationErrors.add(new ConfigurationException("The 'key' property is not required for source with the type " + this.name() + ". The " + MergeDataSourceProcessor.indexString(rowIndex) + " source has a key property configured when it should not"));
                }
                if (source.fields.isEmpty()) {
                    validationErrors.add(new ConfigurationException("The " + MergeDataSourceProcessor.indexString(rowIndex) + " source in " + ((Object)((Object)this)).getClass().getSimpleName() + " has an invalid 'fields' parameter defined. There should be at least most one field defined"));
                }
            }

            @Override
            public void addValuesKeys(Source source, HashSet<String> sourceKeys) {
                sourceKeys.addAll(source.fields.keySet());
            }
        }
        ,
        DATASOURCE{

            @Override
            void add(List<Map<String, ?>> rows, Values values, Source source) throws JRException {
                JRDataSource dataSource = values.getObject(source.key, JRDataSource.class);
                Assert.isTrue((dataSource != null ? 1 : 0) != 0, (String)("The Datasource object referenced by key: " + source.key + " does not exist.  Check that the key is correctly spelled in the config.yaml file.\n\t This is one of the sources for the !mergeDataSources."));
                JRDesignField jrField = new JRDesignField();
                while (dataSource.next()) {
                    HashMap row = Maps.newHashMap();
                    for (Map.Entry<String, String> field : source.fields.entrySet()) {
                        jrField.setName(field.getKey());
                        row.put(field.getValue(), dataSource.getFieldValue((JRField)jrField));
                    }
                    rows.add(row);
                }
            }

            @Override
            void validate(int rowIndex, List<Throwable> validationErrors, Source source) {
                if (source.key.isEmpty()) {
                    validationErrors.add(new ConfigurationException("The " + MergeDataSourceProcessor.indexString(rowIndex) + " source in " + MergeDataSourceProcessor.class.getSimpleName() + " needs to have a 'key' parameter defined."));
                }
                if (source.fields.isEmpty()) {
                    validationErrors.add(new ConfigurationException("The " + MergeDataSourceProcessor.indexString(rowIndex) + " source in " + MergeDataSourceProcessor.class.getSimpleName() + " needs to have a 'fields' parameter defined."));
                }
            }

            @Override
            public void addValuesKeys(Source source, HashSet<String> sourceKeys) {
                sourceKeys.add(source.key);
            }
        };


        abstract void add(List<Map<String, ?>> var1, Values var2, Source var3) throws JRException;

        abstract void validate(int var1, List<Throwable> var2, Source var3);

        abstract void addValuesKeys(Source var1, HashSet<String> var2);
    }

    public static final class Source
    implements ConfigurationObject {
        String key;
        SourceType type;
        Map<String, String> fields = Maps.newHashMap();

        public void setKey(String key) {
            this.key = key;
        }

        public void setType(SourceType type) {
            this.type = type;
        }

        public void setFields(Map<String, String> fields) {
            this.fields = fields;
        }

        static Source createSource(String key, SourceType type) {
            Source source = new Source();
            source.key = key;
            source.type = type;
            return source;
        }

        static Source createSource(String key, SourceType type, Map<String, String> fields) {
            Source source = new Source();
            source.key = key;
            source.type = type;
            source.fields = fields;
            return source;
        }

        @Override
        public void validate(List<Throwable> validationErrors, Configuration config) {
        }
    }

    public static class Out {
        public final JRDataSource mergedDataSource;

        public Out(JRDataSource mergedDataSource) {
            this.mergedDataSource = mergedDataSource;
        }
    }

    public static class In {
        public Values values;
    }
}

