/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.vividsolutions.jts.util.Assert;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.HttpRequestCache;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.OpacitySettingStyleVisitor;

public abstract class AbstractGeotoolsLayer
implements MapLayer {
    private final ExecutorService executorService;
    private final AbstractLayerParams params;

    protected AbstractGeotoolsLayer(ExecutorService executorService, AbstractLayerParams params) {
        this.executorService = executorService;
        this.params = params;
    }

    @Override
    public final Optional<MapLayer> tryAddLayer(MapLayer newLayer) {
        return Optional.absent();
    }

    @Override
    public void prepareRender(MapfishMapContext transformer) {
    }

    @Override
    public final void render(Graphics2D graphics2D, MfClientHttpRequestFactory clientHttpRequestFactory, MapfishMapContext transformer) {
        MapfishMapContext layerTransformer = this.getLayerTransformer(transformer);
        if (!FloatingPointUtil.equals(transformer.getRotation(), 0.0) && !this.supportsNativeRotation()) {
            graphics2D.setTransform(transformer.getTransform());
        }
        Rectangle paintArea = new Rectangle(layerTransformer.getMapSize());
        MapContent content = new MapContent();
        try {
            List<? extends Layer> layers = this.getLayers(clientHttpRequestFactory, layerTransformer);
            this.applyTransparency(layers);
            content.addLayers(layers);
            StreamingRenderer renderer = new StreamingRenderer();
            RenderingHints hints = new RenderingHints(Collections.emptyMap());
            hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE));
            hints.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
            hints.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
            hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            hints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
            hints.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
            graphics2D.addRenderingHints(hints);
            renderer.setJava2DHints(hints);
            HashMap renderHints = Maps.newHashMap();
            if (transformer.isForceLongitudeFirst() != null) {
                renderHints.put("ForceEPSGAxisOrder", transformer.isForceLongitudeFirst());
            }
            renderer.setRendererHints((Map)renderHints);
            renderer.setMapContent(content);
            renderer.setThreadPool(this.executorService);
            ReferencedEnvelope mapArea = layerTransformer.getBounds().toReferencedEnvelope(paintArea);
            renderer.paint(graphics2D, paintArea, mapArea);
        }
        catch (Exception e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
        finally {
            content.dispose();
        }
    }

    @Override
    public double getOpacity() {
        return this.params.opacity;
    }

    private void applyTransparency(List<? extends Layer> layers) {
        double opacity = this.params.opacity;
        Assert.isTrue((opacity > -0.001 && opacity < 1.001 ? 1 : 0) != 0, (String)("Opacity of " + this + " is an illegal value: " + opacity));
        if (1.0 - opacity > 0.001) {
            OpacitySettingStyleVisitor visitor = new OpacitySettingStyleVisitor(opacity);
            for (Layer layer : layers) {
                Style style = layer.getStyle();
                style.accept((StyleVisitor)visitor);
            }
        }
    }

    protected abstract List<? extends Layer> getLayers(MfClientHttpRequestFactory var1, MapfishMapContext var2) throws Exception;

    @Override
    public boolean supportsNativeRotation() {
        return false;
    }

    @Override
    public final String getName() {
        return this.params.name;
    }

    public final boolean getFailOnError() {
        return this.params.failOnError;
    }

    protected final MapfishMapContext getLayerTransformer(MapfishMapContext transformer) {
        MapfishMapContext layerTransformer = transformer;
        if (!FloatingPointUtil.equals(transformer.getRotation(), 0.0) && !this.supportsNativeRotation()) {
            layerTransformer = new MapfishMapContext(transformer, transformer.getRotatedBoundsAdjustedForPreciseRotatedMapSize(), transformer.getRotatedMapSize(), 0.0, transformer.getDPI(), transformer.isForceLongitudeFirst(), transformer.isDpiSensitiveStyle());
        }
        return layerTransformer;
    }

    @Override
    public void cacheResources(HttpRequestCache httpRequestCache, MfClientHttpRequestFactory clientHttpRequestFactory, MapfishMapContext transformer) {
    }
}

