/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import javax.annotation.Nonnull;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.GridType;
import org.mapfish.print.map.geotools.grid.GridUtils;
import org.mapfish.print.map.geotools.grid.LabelPositionCollector;
import org.mapfish.print.map.geotools.grid.PointGridStyle;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

class PointGridStrategy
implements GridType.GridTypeStrategy {
    PointGridStrategy() {
    }

    @Override
    public Style defaultStyle(Template template, GridParam layerData) {
        return PointGridStyle.get(layerData);
    }

    @Override
    public FeatureSourceSupplier createFeatureSource(Template template, final GridParam layerData, final LabelPositionCollector labels) {
        return new FeatureSourceSupplier(){

            @Override
            @Nonnull
            public FeatureSource load(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext mapContext) {
                SimpleFeatureType featureType = GridUtils.createGridFeatureType(mapContext, Point.class);
                SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
                DefaultFeatureCollection features = layerData.numberOfLines != null ? PointGridStrategy.this.createFeaturesFromNumberOfLines(mapContext, featureBuilder, layerData, labels) : PointGridStrategy.this.createFeaturesFromSpacing(mapContext, featureBuilder, layerData, labels);
                return new CollectionFeatureSource((SimpleFeatureCollection)features);
            }
        };
    }

    private DefaultFeatureCollection createFeaturesFromSpacing(MapfishMapContext mapContext, SimpleFeatureBuilder featureBuilder, GridParam layerData, LabelPositionCollector labels) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        CoordinateReferenceSystem mapCrs = bounds.getCoordinateReferenceSystem();
        String unit = layerData.calculateLabelUnit(mapCrs);
        MathTransform labelTransform = layerData.calculateLabelTransform(mapCrs);
        double incrementX = layerData.spacing[0];
        double incrementY = layerData.spacing[1];
        double minX = GridUtils.calculateFirstLine(bounds, layerData, 0);
        double minY = GridUtils.calculateFirstLine(bounds, layerData, 1);
        MapfishMapContext rootContext = mapContext.getRootContext();
        Polygon rotatedBounds = GridUtils.calculateBounds(rootContext);
        AffineTransform worldToScreenTransform = GridUtils.getWorldToScreenTransform(mapContext);
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        int i = 0;
        boolean addBorderFeatures = true;
        for (double x = minX; x < bounds.getMaxX(); x += incrementX) {
            ++i;
            int j = 0;
            if (!this.onRightBorder(bounds, x)) {
                GridUtils.bottomBorderLabel(labels, geometryFactory, rotatedBounds, unit, x, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
                GridUtils.topBorderLabel(labels, geometryFactory, rotatedBounds, unit, x, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
            }
            for (double y = minY; y < bounds.getMaxY(); y += incrementY) {
                ++j;
                if (addBorderFeatures && !this.onRightBorder(bounds, x) && !this.onTopBorder(bounds, y)) {
                    GridUtils.leftBorderLabel(labels, geometryFactory, rotatedBounds, unit, y, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
                    GridUtils.rightBorderLabel(labels, geometryFactory, rotatedBounds, unit, y, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
                }
                if (this.onTopBorder(bounds, y) || this.onBottomBorder(bounds, y) || this.onLeftBorder(bounds, x) || this.onRightBorder(bounds, x)) continue;
                featureBuilder.reset();
                Point geom = geometryFactory.createPoint(new Coordinate(x, y));
                featureBuilder.set("geom", (Object)geom);
                features.add(featureBuilder.buildFeature("grid." + i + "." + j));
            }
            addBorderFeatures = false;
        }
        return features;
    }

    private boolean onRightBorder(ReferencedEnvelope bounds, double x) {
        return x >= bounds.getMaxX();
    }

    private boolean onLeftBorder(ReferencedEnvelope bounds, double x) {
        return x <= bounds.getMinX();
    }

    private boolean onBottomBorder(ReferencedEnvelope bounds, double y) {
        return y <= bounds.getMinY();
    }

    private boolean onTopBorder(ReferencedEnvelope bounds, double y) {
        return y >= bounds.getMaxY();
    }

    private DefaultFeatureCollection createFeaturesFromNumberOfLines(MapfishMapContext mapContext, SimpleFeatureBuilder featureBuilder, GridParam layerData, LabelPositionCollector labels) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        MapfishMapContext rootContext = mapContext.getRootContext();
        Polygon rotatedBounds = GridUtils.calculateBounds(rootContext);
        AffineTransform worldToScreenTransform = GridUtils.getWorldToScreenTransform(mapContext);
        CoordinateReferenceSystem mapCrs = bounds.getCoordinateReferenceSystem();
        String unit = layerData.calculateLabelUnit(mapCrs);
        MathTransform labelTransform = layerData.calculateLabelTransform(mapCrs);
        double incrementX = bounds.getWidth() / (double)(layerData.numberOfLines[0] + 1);
        double incrementY = bounds.getHeight() / (double)(layerData.numberOfLines[1] + 1);
        double x = bounds.getMinX();
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        for (int i = 0; i < layerData.numberOfLines[0] + 2; ++i) {
            double y = bounds.getMinY();
            for (int j = 0; j < layerData.numberOfLines[1] + 2; ++j) {
                String fid = "grid." + i + "." + j;
                if (!(i == 0 && j == 0 || i == layerData.numberOfLines[0] + 1 && j == layerData.numberOfLines[1] + 1 || i == 0 && j == layerData.numberOfLines[1] + 1 || i == layerData.numberOfLines[0] + 1 && j == 0)) {
                    if (i == 0) {
                        GridUtils.leftBorderLabel(labels, geometryFactory, rotatedBounds, unit, y, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
                    } else if (i == layerData.numberOfLines[0] + 1) {
                        GridUtils.rightBorderLabel(labels, geometryFactory, rotatedBounds, unit, y, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
                    } else if (j == 0) {
                        GridUtils.bottomBorderLabel(labels, geometryFactory, rotatedBounds, unit, x, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
                    } else if (j == layerData.numberOfLines[1] + 1) {
                        GridUtils.topBorderLabel(labels, geometryFactory, rotatedBounds, unit, x, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
                    } else {
                        featureBuilder.reset();
                        Point geom = geometryFactory.createPoint(new Coordinate(x, y));
                        featureBuilder.set("geom", (Object)geom);
                        features.add(featureBuilder.buildFeature(fid));
                    }
                }
                y += incrementY;
            }
            x += incrementX;
        }
        return features;
    }
}

