/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.mapfish.print.attribute.HttpRequestHeadersAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.http.AddHeadersProcessor;
import org.mapfish.print.processor.http.ClientHttpFactoryProcessorParam;
import org.mapfish.print.processor.http.HttpProcessor;
import org.mapfish.print.processor.http.matcher.URIMatcher;

public final class ForwardHeadersProcessor
extends AbstractProcessor<Param, Void>
implements HttpProcessor<Param> {
    private final AddHeadersProcessor addHeadersProcessor = new AddHeadersProcessor();
    private Set<String> headerNames = Sets.newHashSet();
    private boolean forwardAll = false;

    public ForwardHeadersProcessor() {
        super(Void.class);
    }

    public void setHeaders(Set<String> names) {
        HashSet<String> lowerCaseNames = new HashSet<String>();
        for (String name : names) {
            lowerCaseNames.add(name.toLowerCase());
        }
        this.headerNames = lowerCaseNames;
    }

    public void setMatchers(List<? extends URIMatcher> matchers) {
        this.addHeadersProcessor.setMatchers(matchers);
    }

    public void setAll(boolean all) {
        this.forwardAll = all;
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        if (!this.forwardAll && this.headerNames.isEmpty()) {
            validationErrors.add(new IllegalStateException("all is false and no headers are defined"));
        }
        if (this.forwardAll && !this.headerNames.isEmpty()) {
            validationErrors.add(new IllegalStateException("all is true but headers is defined. Either all is true OR headers is specified"));
        }
    }

    @Override
    public MfClientHttpRequestFactory createFactoryWrapper(Param param, MfClientHttpRequestFactory requestFactory) {
        HashMap headers = Maps.newHashMap();
        for (Map.Entry<String, List<String>> entry : param.requestHeaders.getHeaders().entrySet()) {
            if (!this.forwardAll && !this.headerNames.contains(entry.getKey().toLowerCase())) continue;
            headers.put(entry.getKey(), entry.getValue());
        }
        this.addHeadersProcessor.setHeaders(headers);
        return this.addHeadersProcessor.createFactoryWrapper(param, requestFactory);
    }

    @Override
    @Nullable
    public Param createInputParameter() {
        return new Param();
    }

    @Override
    @Nullable
    public Void execute(Param values, Processor.ExecutionContext context) throws Exception {
        values.clientHttpRequestFactoryProvider.set(this.createFactoryWrapper(values, values.clientHttpRequestFactoryProvider.get()));
        return null;
    }

    public static class Param
    extends ClientHttpFactoryProcessorParam {
        public HttpRequestHeadersAttribute.Value requestHeaders;
    }
}

