/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.map.scalebar;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import org.mapfish.print.attribute.ScalebarAttribute;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.jasper.ImagesSubReport;
import org.mapfish.print.processor.map.scalebar.ScalebarGraphic;

public class CreateScalebarProcessor
extends AbstractProcessor<Input, Output> {
    protected CreateScalebarProcessor() {
        super(Output.class);
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
    }

    @Override
    public final Input createInputParameter() {
        return new Input();
    }

    @Override
    public final Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        this.checkCancelState(context);
        URI scalebarGraphicFile = this.createScalebarGraphic(values);
        this.checkCancelState(context);
        String strScalebarSubReport = null;
        if (values.scalebar.isCreateSubReport()) {
            URI scalebarSubReport = this.createScalebarSubReport(values.tempTaskDirectory, values.scalebar.getSize(), Lists.newArrayList((Object[])new URI[]{scalebarGraphicFile}), values.mapContext.getDPI());
            strScalebarSubReport = scalebarSubReport.toString();
        }
        return new Output(scalebarGraphicFile.toString(), strScalebarSubReport);
    }

    private URI createScalebarGraphic(Input values) throws IOException, ParserConfigurationException {
        ScalebarGraphic scalebar = new ScalebarGraphic();
        return scalebar.render(values.mapContext, values.scalebar, values.tempTaskDirectory, values.template);
    }

    private URI createScalebarSubReport(File printDirectory, Dimension size, List<URI> graphics, double dpi) throws IOException, JRException {
        ImagesSubReport subReport = new ImagesSubReport(graphics, size, dpi);
        File compiledReport = File.createTempFile("scalebar-report-", ".jasper", printDirectory);
        subReport.compile(compiledReport);
        return compiledReport.toURI();
    }

    public static final class Output {
        public final String scalebarGraphic;
        public final String scalebarSubReport;

        private Output(String scalebarGraphic, String subReport) {
            this.scalebarGraphic = scalebarGraphic;
            this.scalebarSubReport = subReport;
        }
    }

    public static class Input {
        public MapfishMapContext mapContext;
        public ScalebarAttribute.ScalebarAttributeValues scalebar;
        public File tempTaskDirectory;
        public Template template;
    }
}

