/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job.impl;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.hibernate.annotations.Type;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.config.access.AndAccessAssertion;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.springframework.context.ApplicationContext;

@Embeddable
public class PrintJobEntryImpl
implements PrintJobEntry {
    private static final int LENGTH_JSON = 1024;
    @Column(insertable=false, updatable=false)
    private String referenceId;
    @Column(length=1024)
    @Type(type="org.mapfish.print.servlet.job.impl.hibernate.PJsonObjectUserType")
    private PJsonObject requestData;
    @Column
    private long startTime;
    @Column(length=1024)
    @Type(type="org.mapfish.print.servlet.job.impl.hibernate.AccessAssertionUserType")
    private AccessAssertion access;

    public PrintJobEntryImpl() {
    }

    public PrintJobEntryImpl(String referenceId, PJsonObject requestData, long startTime) {
        this.referenceId = referenceId;
        this.requestData = requestData;
        this.startTime = startTime;
    }

    public PrintJobEntryImpl(String referenceId, PJsonObject requestData, long startTime, AccessAssertion access) {
        this.referenceId = referenceId;
        this.requestData = requestData;
        this.access = access;
        this.startTime = startTime;
    }

    public final void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public final void setRequestData(PJsonObject requestData) {
        this.requestData = requestData;
    }

    public final void setAccess(AccessAssertion access) {
        this.access = access;
    }

    @Override
    public final String getReferenceId() {
        return this.referenceId;
    }

    @Override
    public final PJsonObject getRequestData() {
        return this.requestData;
    }

    @Override
    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @Override
    public final Date getStartDate() {
        return new Date(this.startTime);
    }

    @Override
    public final AccessAssertion getAccess() {
        return this.access;
    }

    @Override
    public final String getAppId() {
        return this.getRequestData().optString("app", "default");
    }

    @Override
    public final long getTimeSinceStart() {
        return System.currentTimeMillis() - this.getStartTime();
    }

    @Override
    public final void assertAccess() {
        this.access.assertAccess(this.getClass().getSimpleName() + " for app '" + this.getAppId() + "' for print job '" + this.getReferenceId() + "'", this);
    }

    public final void configureAccess(Template template, ApplicationContext context) {
        Configuration configuration = template.getConfiguration();
        AndAccessAssertion accessAssertion = (AndAccessAssertion)context.getBean(AndAccessAssertion.class);
        accessAssertion.setPredicates(configuration.getAccessAssertion(), template.getAccessAssertion());
        this.access = accessAssertion;
    }
}

