/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.access;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.access.AccessAssertion;
import org.mapfish.print.config.access.AccessAssertionPersister;
import org.springframework.beans.factory.annotation.Autowired;

public final class AndAccessAssertion
implements AccessAssertion {
    private static final String JSON_ARRAY = "data";
    private List<AccessAssertion> predicates;
    @Autowired
    private AccessAssertionPersister persister;

    public void setPredicates(AccessAssertion ... predicates) {
        if (this.predicates != null) {
            throw new AssertionError((Object)"Predicates can only be set a single time");
        }
        if (predicates.length < 1) {
            throw new IllegalArgumentException("There must be at least 1 predicate");
        }
        this.predicates = Arrays.asList(predicates);
    }

    @Override
    public void assertAccess(String resourceDescription, Object protectedResource) {
        for (AccessAssertion predicate : this.predicates) {
            predicate.assertAccess(resourceDescription, protectedResource);
        }
    }

    @Override
    public JSONObject marshal() {
        try {
            JSONObject marshalData = new JSONObject();
            JSONArray array = new JSONArray();
            marshalData.put(JSON_ARRAY, (Object)array);
            if (this.predicates != null) {
                for (AccessAssertion predicate : this.predicates) {
                    JSONObject predicateMarshalData = this.persister.marshal(predicate);
                    array.put((Object)predicateMarshalData);
                }
            }
            return marshalData;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unmarshal(JSONObject encodedAssertion) {
        try {
            this.predicates = Lists.newArrayList();
            JSONArray marshalData = encodedAssertion.getJSONArray(JSON_ARRAY);
            for (int i = 0; i < marshalData.length(); ++i) {
                JSONObject predicateData = marshalData.getJSONObject(i);
                AccessAssertion predicate = this.persister.unmarshal(predicateData);
                this.predicates.add(predicate);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        for (AccessAssertion predicate : this.predicates) {
            predicate.validate(validationErrors, configuration);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof AndAccessAssertion) {
            return ((AndAccessAssertion)o).predicates.equals(this.predicates);
        }
        return false;
    }

    public int hashCode() {
        return this.predicates.hashCode();
    }

    @Override
    public AccessAssertion copy() {
        AndAccessAssertion assertion = new AndAccessAssertion();
        assertion.predicates = new ArrayList<AccessAssertion>(this.predicates);
        assertion.persister = this.persister;
        return assertion;
    }
}

