/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.AbstractGeotoolsLayer;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.StyleSupplier;

public abstract class AbstractFeatureSourceLayer
extends AbstractGeotoolsLayer {
    private FeatureSourceSupplier featureSourceSupplier;
    private FeatureSource<?, ?> featureSource = null;
    private StyleSupplier<FeatureSource> styleSupplier;
    private final Boolean renderAsSvg;

    public AbstractFeatureSourceLayer(ExecutorService executorService, FeatureSourceSupplier featureSourceSupplier, StyleSupplier<FeatureSource> styleSupplier, boolean renderAsSvg, AbstractLayerParams params) {
        super(executorService, params);
        this.featureSourceSupplier = featureSourceSupplier;
        this.styleSupplier = styleSupplier;
        this.renderAsSvg = renderAsSvg;
    }

    public final void setStyle(StyleSupplier style) {
        this.styleSupplier = style;
    }

    public final FeatureSource<?, ?> getFeatureSource(@Nonnull MfClientHttpRequestFactory httpRequestFactory, @Nonnull MapfishMapContext mapContext) {
        if (this.featureSource == null) {
            this.featureSource = this.featureSourceSupplier.load(httpRequestFactory, mapContext);
        }
        return this.featureSource;
    }

    @Override
    public final List<? extends Layer> getLayers(@Nonnull MfClientHttpRequestFactory httpRequestFactory, @Nonnull MapfishMapContext mapContext) throws Exception {
        FeatureSource<?, ?> source = this.getFeatureSource(httpRequestFactory, mapContext);
        Style style = this.styleSupplier.load(httpRequestFactory, source);
        if (mapContext.isDpiSensitiveStyle().booleanValue()) {
            double scaleFactor = mapContext.getDPI() / 72.0;
            RescaleStyleVisitor scale = new RescaleStyleVisitor(scaleFactor);
            style.accept((StyleVisitor)scale);
            style = (Style)scale.getCopy();
        }
        return Lists.newArrayList((Object[])new FeatureLayer[]{new FeatureLayer(source, style)});
    }

    public final void setFeatureCollection(final SimpleFeatureCollection featureCollection) {
        this.featureSourceSupplier = new FeatureSourceSupplier(){

            @Override
            @Nonnull
            public FeatureSource load(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext mapContext) {
                DefaultFeatureCollection copy = DataUtilities.collection((FeatureCollection)featureCollection);
                return new CollectionFeatureSource((SimpleFeatureCollection)copy);
            }
        };
    }

    @Override
    public final MapLayer.RenderType getRenderType() {
        return this.renderAsSvg != false ? MapLayer.RenderType.SVG : MapLayer.RenderType.UNKNOWN;
    }

    @Override
    public final double getImageBufferScaling() {
        return 1.0;
    }
}

