/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.io.IOUtils;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpResponse;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class HttpRequestCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestCache.class);
    private final List<CachedClientHttpRequest> requests = new ArrayList<CachedClientHttpRequest>();
    private final File temporaryDirectory;
    private final MetricRegistry registry;
    private boolean cached = false;

    public HttpRequestCache(File temporaryDirectory, MetricRegistry registry) {
        this.temporaryDirectory = temporaryDirectory;
        this.registry = registry;
    }

    private CachedClientHttpRequest save(CachedClientHttpRequest request) {
        this.requests.add(request);
        return request;
    }

    public ClientHttpRequest register(ClientHttpRequest originalRequest) throws IOException {
        return this.save(new CachedClientHttpRequest(originalRequest));
    }

    public ClientHttpRequest register(MfClientHttpRequestFactory factory, URI uri) throws IOException {
        return this.register(factory.createRequest(uri, HttpMethod.GET));
    }

    public void cache(ForkJoinPool requestForkJoinPool) {
        if (!this.cached) {
            requestForkJoinPool.invokeAll(this.requests);
            this.cached = true;
        } else {
            LOGGER.warn("Attempting to cache twice!");
        }
    }

    private class CachedClientHttpRequest
    implements ClientHttpRequest,
    Callable<Void> {
        private final ClientHttpRequest originalRequest;
        private CachedClientHttpResponse response;

        public CachedClientHttpRequest(ClientHttpRequest request) throws IOException {
            this.originalRequest = request;
        }

        public HttpMethod getMethod() {
            return this.originalRequest.getMethod();
        }

        public URI getURI() {
            return this.originalRequest.getURI();
        }

        public HttpHeaders getHeaders() {
            return this.originalRequest.getHeaders();
        }

        public OutputStream getBody() throws IOException {
            throw new UnsupportedOperationException();
        }

        public ClientHttpResponse execute() throws IOException {
            if (!HttpRequestCache.this.cached) {
                LOGGER.warn("Attempting to load cached URI before actual caching: " + this.originalRequest.getURI());
            } else if (this.response == null) {
                LOGGER.warn("Attempting to load cached URI from failed request: " + this.originalRequest.getURI());
            } else {
                LOGGER.debug("Loading cached URI resource " + this.originalRequest.getURI());
            }
            return this.response;
        }

        @Override
        public Void call() throws Exception {
            String baseMetricName = HttpRequestCache.class.getName() + ".read." + this.getURI().getHost();
            Timer.Context timerDownload = HttpRequestCache.this.registry.timer(baseMetricName).time();
            ClientHttpResponse originalResponse = null;
            try {
                originalResponse = this.originalRequest.execute();
                LOGGER.debug("Caching URI resource " + this.originalRequest.getURI());
                this.response = new CachedClientHttpResponse(originalResponse);
            }
            catch (IOException e) {
                LOGGER.error("Request failed " + this.originalRequest.getURI(), (Throwable)e);
                HttpRequestCache.this.registry.counter(baseMetricName + ".error").inc();
                throw e;
            }
            finally {
                if (originalResponse != null) {
                    originalResponse.close();
                }
                timerDownload.stop();
            }
            return null;
        }
    }

    private class CachedClientHttpResponse
    extends AbstractClientHttpResponse {
        private final File cachedFile;
        private final HttpHeaders headers;
        private final int status;
        private final String statusText;
        private InputStream body;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CachedClientHttpResponse(ClientHttpResponse originalResponse) throws IOException {
            this.headers = originalResponse.getHeaders();
            this.status = originalResponse.getRawStatusCode();
            this.statusText = originalResponse.getStatusText();
            this.cachedFile = File.createTempFile("cacheduri", null, HttpRequestCache.this.temporaryDirectory);
            try (InputStream is = originalResponse.getBody();
                 FileOutputStream os = new FileOutputStream(this.cachedFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
        }

        public InputStream getBody() throws IOException {
            if (this.body == null) {
                this.body = new FileInputStream(this.cachedFile);
            }
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public int getRawStatusCode() throws IOException {
            return this.status;
        }

        public String getStatusText() throws IOException {
            return this.statusText;
        }

        public void close() {
            if (this.body != null) {
                try {
                    this.body.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

