/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.vividsolutions.jts.util.Assert;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import javax.swing.JLabel;
import org.mapfish.print.map.geotools.grid.FontStyle;
import org.mapfish.print.parser.HasDefaultValue;

public final class GridFontParam {
    private static final Font DEFAULT_FONT_NAME = new JLabel().getFont();
    private static final int DEFAULT_FONT_SIZE = 10;
    @HasDefaultValue
    public String[] name = new String[]{DEFAULT_FONT_NAME.getFontName()};
    @HasDefaultValue
    public int size = 10;
    @HasDefaultValue
    public FontStyle style = FontStyle.BOLD;

    public void postConstruct() {
        Assert.isTrue((this.name != null ? 1 : 0) != 0, (String)"name parameter cannot be null");
        Assert.isTrue((this.style != null ? 1 : 0) != 0, (String)"style parameter cannot be null");
        Assert.isTrue((this.size > 1 ? 1 : 0) != 0, (String)"size must be greater than 1");
        Font baseFont = null;
        for (String fontName : this.name) {
            try {
                baseFont = new Font(fontName, this.style.styleId, this.size);
                break;
            }
            catch (Exception exception) {
            }
        }
        if (baseFont == null) {
            Object[] legalFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            throw new IllegalArgumentException(Arrays.toString(this.name) + " does not contain a font that can be created by this Java Virtual Machine, legal options are: \n" + Arrays.toString(legalFonts));
        }
    }
}

