/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.job;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.OutputStream;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.servlet.NoSuchAppException;
import org.mapfish.print.servlet.job.PrintJobEntry;
import org.mapfish.print.servlet.job.PrintJobResult;
import org.mapfish.print.servlet.job.impl.PrintJobEntryImpl;
import org.mapfish.print.servlet.job.impl.PrintJobResultImpl;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class PrintJob
implements Callable<PrintJobResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintJob.class);
    private PrintJobEntry entry;
    @Autowired
    private MapPrinterFactory mapPrinterFactory;
    @Autowired
    private MetricRegistry metricRegistry;
    private SecurityContext securityContext;

    public final PrintJobEntry getEntry() {
        return this.entry;
    }

    public final void setEntry(PrintJobEntry entry) {
        this.entry = entry;
    }

    protected abstract URI withOpenOutputStream(PrintAction var1) throws Exception;

    protected PrintJobResult createResult(URI reportURI, String fileName, String fileExtension, String mimeType, String referenceId) {
        return new PrintJobResultImpl(reportURI, fileName, fileExtension, mimeType, referenceId);
    }

    @Override
    public final PrintJobResult call() throws Exception {
        SecurityContextHolder.setContext((SecurityContext)this.securityContext);
        Timer.Context timer = this.metricRegistry.timer(this.getClass().getName() + " call()").time();
        PJsonObject spec = null;
        MapPrinter mapPrinter = null;
        try {
            MDC.put((String)"job_id", (String)this.entry.getReferenceId());
            LOGGER.info("Starting print job " + this.entry.getReferenceId());
            spec = this.entry.getRequestData();
            final MapPrinter finalMapPrinter = mapPrinter = this.mapPrinterFactory.create(this.entry.getAppId());
            URI reportURI = this.withOpenOutputStream(new PrintAction(){

                @Override
                public void run(OutputStream outputStream) throws Exception {
                    finalMapPrinter.print(PrintJob.this.entry.getReferenceId(), PrintJob.this.entry.getRequestData(), outputStream);
                }
            });
            this.metricRegistry.counter(this.getClass().getName() + "success").inc();
            LOGGER.info("Successfully completed print job " + this.entry.getReferenceId());
            LOGGER.debug("Job " + this.entry.getReferenceId() + "\n" + this.entry.getRequestData());
            String fileName = PrintJob.getFileName(mapPrinter, spec);
            String mimeType = null;
            String fileExtension = null;
            if (mapPrinter != null) {
                OutputFormat outputFormat = mapPrinter.getOutputFormat(spec);
                mimeType = outputFormat.getContentType();
                fileExtension = outputFormat.getFileSuffix();
            }
            PrintJobResult printJobResult = this.createResult(reportURI, fileName, fileExtension, mimeType, this.entry.getReferenceId());
            return printJobResult;
        }
        catch (Exception e) {
            String canceledText = "";
            if (Thread.currentThread().isInterrupted()) {
                canceledText = "(canceled) ";
            }
            LOGGER.info("Error executing print job " + canceledText + this.entry.getReferenceId() + "\n" + this.entry.getRequestData(), (Throwable)e);
            this.metricRegistry.counter(this.getClass().getName() + "failure").inc();
            throw e;
        }
        finally {
            long stop = TimeUnit.MILLISECONDS.convert(timer.stop(), TimeUnit.NANOSECONDS);
            LOGGER.debug("Print Job " + this.entry.getReferenceId() + " completed in " + stop + "ms");
        }
    }

    private static String getFileName(@Nullable MapPrinter mapPrinter, PJsonObject spec) {
        String fileName = spec.optString("outputFilename");
        if (fileName != null) {
            return fileName;
        }
        if (mapPrinter != null) {
            String templateName;
            Configuration config = mapPrinter.getConfiguration();
            Template template = config.getTemplate(templateName = spec.getString("layout"));
            if (template.getOutputFilename() != null) {
                return template.getOutputFilename();
            }
            if (config.getOutputFilename() != null) {
                return config.getOutputFilename();
            }
        }
        return "mapfish-print-report";
    }

    public final void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = SecurityContextHolder.createEmptyContext();
        this.securityContext.setAuthentication(securityContext.getAuthentication());
    }

    final void initForTesting(ApplicationContext context) {
        this.metricRegistry = (MetricRegistry)context.getBean(MetricRegistry.class);
        this.mapPrinterFactory = new MapPrinterFactory(){

            @Override
            public MapPrinter create(String app) throws NoSuchAppException {
                return null;
            }

            @Override
            public Set<String> getAppIds() {
                return null;
            }
        };
        this.entry = new PrintJobEntryImpl();
    }

    protected static interface PrintAction {
        public void run(OutputStream var1) throws Exception;
    }
}

