/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import com.google.common.collect.Lists;
import com.vividsolutions.jts.util.Assert;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.ConfigurableRequest;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class ConfigFileResolvingHttpRequestFactory
implements MfClientHttpRequestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigFileResolvingHttpRequestFactory.class);
    private final Configuration config;
    private final String jobId;
    private final MfClientHttpRequestFactoryImpl httpRequestFactory;
    private final List<MfClientHttpRequestFactory.RequestConfigurator> callbacks = Lists.newCopyOnWriteArrayList();

    public ConfigFileResolvingHttpRequestFactory(MfClientHttpRequestFactoryImpl httpRequestFactory, Configuration config, String jobId) {
        this.httpRequestFactory = httpRequestFactory;
        this.config = config;
        this.jobId = jobId;
    }

    @Override
    public void register(@Nonnull MfClientHttpRequestFactory.RequestConfigurator callback) {
        this.callbacks.add(callback);
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new ConfigFileResolvingRequest(uri, httpMethod);
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    private class ConfigFileResolvingRequest
    extends AbstractClientHttpRequest {
        private final URI uri;
        private final HttpMethod httpMethod;
        private ClientHttpRequest request;

        ConfigFileResolvingRequest(@Nonnull URI uri, HttpMethod httpMethod) {
            this.uri = uri;
            this.httpMethod = httpMethod;
        }

        protected synchronized OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
            Assert.isTrue((this.request == null ? 1 : 0) != 0, (String)"getBodyInternal() can only be called once.");
            this.request = this.createRequestFromWrapped(headers);
            return this.request.getBody();
        }

        private synchronized ClientHttpRequest createRequestFromWrapped(HttpHeaders headers) throws IOException {
            MfClientHttpRequestFactoryImpl requestFactory = ConfigFileResolvingHttpRequestFactory.this.httpRequestFactory;
            ConfigurableRequest httpRequest = requestFactory.createRequest(this.uri, this.httpMethod);
            httpRequest.setConfiguration(ConfigFileResolvingHttpRequestFactory.this.config);
            httpRequest.getHeaders().putAll((Map)headers);
            httpRequest.getHeaders().set("X-Request-ID", ConfigFileResolvingHttpRequestFactory.this.jobId);
            return httpRequest;
        }

        /*
         * Exception decompiling
         */
        protected synchronized ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private ClientHttpResponse executeCallbacksAndRequest(ClientHttpRequest requestToExecute) throws IOException {
            for (MfClientHttpRequestFactory.RequestConfigurator callback : ConfigFileResolvingHttpRequestFactory.this.callbacks) {
                callback.configureRequest(requestToExecute);
            }
            return requestToExecute.execute();
        }

        public HttpMethod getMethod() {
            return this.httpMethod;
        }

        public URI getURI() {
            return this.uri;
        }

        private class ConfigFileResolverHttpResponse
        implements ClientHttpResponse {
            private final HttpHeaders headers;
            private final byte[] bytes;

            ConfigFileResolverHttpResponse(byte[] bytes, HttpHeaders headers) {
                this.headers = headers;
                this.bytes = bytes;
            }

            public HttpStatus getStatusCode() throws IOException {
                return HttpStatus.OK;
            }

            public int getRawStatusCode() throws IOException {
                return this.getStatusCode().value();
            }

            public String getStatusText() throws IOException {
                return "OK";
            }

            public void close() {
            }

            public InputStream getBody() throws IOException {
                return new ByteArrayInputStream(this.bytes);
            }

            public HttpHeaders getHeaders() {
                return this.headers;
            }
        }
    }
}

