/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.ConfigurationObject;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;

public final class ZoomLevels
implements ConfigurationObject {
    private double[] scaleDenominators;

    public ZoomLevels(double ... scaleDenominators) {
        this.setScales(scaleDenominators);
    }

    public ZoomLevels() {
    }

    public void setScales(double[] newScaleDenominators) {
        int i;
        TreeSet<Double> sortedSet = new TreeSet<Double>((Comparator<Double>)Ordering.natural().reverse());
        for (i = 0; i < newScaleDenominators.length; ++i) {
            sortedSet.add(newScaleDenominators[i]);
        }
        this.scaleDenominators = new double[sortedSet.size()];
        i = 0;
        for (Double scaleDenominator : sortedSet) {
            this.scaleDenominators[i] = scaleDenominator;
            ++i;
        }
    }

    public int size() {
        return this.scaleDenominators.length;
    }

    public Scale get(int index, DistanceUnit unit) {
        return new Scale(this.scaleDenominators[index], unit, 72.0);
    }

    public String toString() {
        return Arrays.toString(this.scaleDenominators);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoomLevels that = (ZoomLevels)o;
        return Arrays.equals(this.scaleDenominators, that.scaleDenominators);
    }

    public int hashCode() {
        return Arrays.hashCode(this.scaleDenominators);
    }

    @Override
    public void validate(List<Throwable> validationErrors, Configuration configuration) {
        if (this.scaleDenominators == null || this.scaleDenominators.length == 0) {
            validationErrors.add(new ConfigurationException("There are no scales defined in " + this.getClass().getName()));
        }
    }

    public double[] getScaleDenominators() {
        double[] dest = new double[this.scaleDenominators.length];
        System.arraycopy(this.scaleDenominators, 0, dest, 0, this.scaleDenominators.length);
        return dest;
    }
}

