/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.mapfish.print.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkingDirectories {
    private static final String TASK_DIR_PREFIX = "task-";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkingDirectories.class);
    private File working;
    private File reports;
    private int maxAgeReport;
    private int maxAgeTaskDir;

    public final void setWorking(File working) {
        this.working = working;
    }

    public final File getWorking() {
        return this.working;
    }

    public final void setMaxAgeReport(int maxAgeReport) {
        this.maxAgeReport = maxAgeReport;
    }

    public final void setMaxAgeTaskDir(int maxAgeTaskDir) {
        this.maxAgeTaskDir = maxAgeTaskDir;
    }

    @PostConstruct
    public final void init() {
        this.reports = new File(this.working, "reports");
    }

    public final File getJasperCompilation(Configuration configuration) {
        File jasperCompilation = new File(this.getWorking(configuration), "jasper-bin");
        this.createIfMissing(jasperCompilation, "Jasper Compilation");
        return jasperCompilation;
    }

    public final File getReports() {
        this.createIfMissing(this.reports, "Reports");
        return this.reports;
    }

    public final File getTaskDirectory() {
        this.createIfMissing(this.working, "Working");
        try {
            return Files.createTempDirectory(this.working.toPath(), TASK_DIR_PREFIX, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Unable to create temporary directory in '" + this.working + "'"));
        }
    }

    public final void removeDirectory(File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            LOGGER.error("Unable to delete directory '" + directory + "'");
        }
    }

    private void createIfMissing(File directory, String name) {
        if (!(directory.exists() || directory.mkdirs() || directory.exists())) {
            throw new AssertionError((Object)("Unable to create working directory: '" + directory + "' it is the '" + name + "' directory"));
        }
    }

    public final File getBuildFileFor(Configuration configuration, File jasperFileXml, String extension, Logger logger) {
        String relativePathToFile;
        String configurationAbsolutePath = configuration.getDirectory().getPath();
        int prefixToConfiguration = configurationAbsolutePath.length() + 1;
        String parentDir = jasperFileXml.getAbsoluteFile().getParent();
        if (configurationAbsolutePath.equals(parentDir)) {
            relativePathToFile = com.google.common.io.Files.getNameWithoutExtension((String)jasperFileXml.getName());
        } else {
            String relativePathToContainingDirectory = parentDir.substring(prefixToConfiguration);
            relativePathToFile = relativePathToContainingDirectory + File.separator + com.google.common.io.Files.getNameWithoutExtension((String)jasperFileXml.getName());
        }
        File buildFile = new File(this.getJasperCompilation(configuration), relativePathToFile + extension);
        if (!buildFile.getParentFile().exists() && !buildFile.getParentFile().mkdirs()) {
            logger.error("Unable to create directory for containing compiled jasper report templates: " + buildFile.getParentFile());
        }
        return buildFile;
    }

    public final File getWorking(Configuration configuration) {
        return new File(this.working, configuration.getDirectory().getName());
    }

    public final Runnable getCleanUpTask() {
        return new CleanUpTask(this.maxAgeReport, this.maxAgeTaskDir);
    }

    @VisibleForTesting
    class CleanUpTask
    implements Runnable {
        private final long maxAgeReport;
        private final long maxAgeTaskDir;

        public CleanUpTask(long maxAgeReport, long maxAgeTaskDir) {
            this.maxAgeReport = maxAgeReport;
            this.maxAgeTaskDir = maxAgeTaskDir;
        }

        @Override
        public void run() {
            try {
                this.removeOldFiles(WorkingDirectories.this.reports, null, this.maxAgeReport);
                this.removeOldFiles(WorkingDirectories.this.working, WorkingDirectories.TASK_DIR_PREFIX, this.maxAgeTaskDir);
                this.removeOldFiles(new File(System.getProperty("java.io.tmpdir")), "+~JF", this.maxAgeTaskDir);
            }
            catch (Exception e) {
                LOGGER.error("error running file clean-up task", (Throwable)e);
            }
        }

        private void removeOldFiles(File dir, String prefix, long maxAge) {
            long ageThreshold = new Date().getTime() - maxAge * 1000L;
            int deletedFiles = 0;
            if (dir.exists()) {
                for (File file : dir.listFiles()) {
                    if (prefix != null && !file.getName().startsWith(prefix) || file.lastModified() >= ageThreshold) continue;
                    if (!FileUtils.deleteQuietly((File)file)) {
                        LOGGER.warn("failed to delete file " + file.getAbsolutePath());
                        continue;
                    }
                    ++deletedFiles;
                }
            }
            LOGGER.info("deleted " + deletedFiles + " old file(s) in " + dir.getPath());
        }
    }
}

