/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.oldapi;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.Constants;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.MapPrinterFactory;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.attribute.map.MapAttribute;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.Template;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;
import org.mapfish.print.servlet.BaseMapServlet;
import org.mapfish.print.servlet.MapPrinterServlet;
import org.mapfish.print.servlet.NoSuchAppException;
import org.mapfish.print.servlet.job.JobManager;
import org.mapfish.print.servlet.job.NoSuchReferenceException;
import org.mapfish.print.servlet.oldapi.OldAPIRequestConverter;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class OldAPIMapPrinterServlet
extends BaseMapServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldAPIMapPrinterServlet.class);
    static final String REPORT_SUFFIX = ".printout";
    private static final String DEP_SEG = "/dep";
    private static final String INFO_URL = "/info.json";
    private static final String DEP_INFO_URL = "/dep/info.json";
    private static final String PRINT_URL = "/print.pdf";
    private static final String DEP_PRINT_URL = "/dep/print.pdf";
    private static final String CREATE_URL = "/create.json";
    private static final String DEP_CREATE_URL = "/dep/create.json";
    private static final int HALF_SECOND = 500;
    static final String JSON_PRINT_URL = "printURL";
    static final String JSON_CREATE_URL = "createURL";
    @Autowired
    private MapPrinterFactory printerFactory;
    @Autowired
    private MapPrinterServlet primaryApiServlet;
    @Autowired
    private JobManager jobManager;

    @RequestMapping(value={"/dep/print.pdf"}, method={RequestMethod.POST})
    public final void printReportPost(@RequestBody String requestData, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (Strings.isNullOrEmpty((String)requestData)) {
            OldAPIMapPrinterServlet.error(httpServletResponse, "Missing 'spec' parameter", HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        this.createAndGetPDF(httpServletRequest, httpServletResponse, requestData);
    }

    @RequestMapping(value={"/dep/print.pdf"}, method={RequestMethod.GET})
    public final void printReport(@RequestParam(value="spec", defaultValue="") String spec, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        if (Strings.isNullOrEmpty((String)spec)) {
            OldAPIMapPrinterServlet.error(httpServletResponse, "Missing 'spec' parameter", HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        this.createAndGetPDF(httpServletRequest, httpServletResponse, spec);
    }

    @RequestMapping(value={"/dep/create.json**"}, method={RequestMethod.POST})
    public final void createReportPost(@RequestParam(value="url", defaultValue="") String baseUrl, @RequestParam(value="spec", required=false) String spec, @RequestBody String requestData, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, JSONException {
        if (Strings.isNullOrEmpty((String)requestData)) {
            OldAPIMapPrinterServlet.error(httpServletResponse, "Missing 'spec' parameter", HttpStatus.INTERNAL_SERVER_ERROR);
            return;
        }
        String baseUrlPath = this.getBaseUrl(DEP_CREATE_URL, URLDecoder.decode(baseUrl, Constants.DEFAULT_ENCODING), httpServletRequest);
        String specData = spec == null ? requestData : spec;
        this.createPDF(httpServletRequest, httpServletResponse, baseUrlPath, specData);
    }

    private void createAndGetPDF(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String spec) {
        try {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
        try {
            String jobRef = this.doCreatePDFFile(spec, httpServletRequest, httpServletResponse);
            this.primaryApiServlet.getReport(jobRef, false, httpServletResponse);
        }
        catch (NoSuchAppException e) {
            OldAPIMapPrinterServlet.error(httpServletResponse, e.getMessage(), HttpStatus.NOT_FOUND);
        }
        catch (Throwable e) {
            this.error(httpServletResponse, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createPDF(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String basePath, String spec) throws IOException, JSONException {
        try {
            try {
                String jobRef = this.doCreatePDFFile(spec, httpServletRequest, httpServletResponse);
                httpServletResponse.setContentType("application/json; charset=utf-8");
                try (PrintWriter writer = null;){
                    writer = httpServletResponse.getWriter();
                    JSONWriter json = new JSONWriter((Appendable)writer);
                    json.object();
                    json.key("getURL").value((Object)(basePath + "/" + jobRef + REPORT_SUFFIX));
                    json.endObject();
                }
            }
            catch (NoSuchAppException e) {
                OldAPIMapPrinterServlet.error(httpServletResponse, e.getMessage(), HttpStatus.NOT_FOUND);
                return;
            }
        }
        catch (Throwable e) {
            this.error(httpServletResponse, e);
            return;
        }
    }

    @RequestMapping(value={"/dep/{id:.+}.printout"})
    public final void getFile(@PathVariable String id, @RequestParam(value="inline", defaultValue="false") boolean inline, HttpServletResponse response) throws IOException, ServletException {
        this.primaryApiServlet.getReport(id, inline, response);
    }

    @RequestMapping(value={"/dep/info.json"})
    public final void getInfo(@RequestParam(value="url", defaultValue="") String baseUrl, @RequestParam(value="var", defaultValue="") String jsonpVar, @RequestParam(value="app", defaultValue="default") String appId, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        MapPrinter printer;
        try {
            printer = this.printerFactory.create(appId);
        }
        catch (NoSuchAppException e) {
            OldAPIMapPrinterServlet.error(resp, e.getMessage(), HttpStatus.NOT_FOUND);
            return;
        }
        resp.setContentType("application/json; charset=utf-8");
        try (PrintWriter writer = resp.getWriter();){
            if (!Strings.isNullOrEmpty((String)jsonpVar)) {
                writer.print("var " + jsonpVar + "=");
            }
            JSONWriter json = new JSONWriter((Appendable)writer);
            try {
                json.object();
                this.writeInfoJson(json, baseUrl, printer, req);
                json.endObject();
            }
            catch (JSONException e) {
                throw new ServletException((Throwable)e);
            }
            if (!Strings.isNullOrEmpty((String)jsonpVar)) {
                writer.print(";");
            }
        }
    }

    private void writeInfoJson(JSONWriter json, String baseUrl, MapPrinter printer, HttpServletRequest req) throws JSONException {
        json.key("outputFormats");
        json.array();
        for (String format : printer.getOutputFormatsNames()) {
            json.object();
            json.key("name").value((Object)format);
            json.endObject();
        }
        json.endArray();
        this.writeInfoLayouts(json, printer.getConfiguration());
        String urlToUseInSpec = this.getBaseUrl(DEP_INFO_URL, baseUrl, req);
        json.key(JSON_PRINT_URL).value((Object)(urlToUseInSpec + PRINT_URL));
        json.key(JSON_CREATE_URL).value((Object)(urlToUseInSpec + CREATE_URL));
    }

    private void writeInfoLayouts(JSONWriter json, Configuration configuration) throws JSONException {
        Double maxDpi = null;
        double[] dpiSuggestions = null;
        ZoomLevels zoomLevels = null;
        json.key("layouts");
        json.array();
        for (String name : configuration.getTemplates().keySet()) {
            json.object();
            json.key("name").value((Object)name);
            json.key("rotation").value(true);
            Template template = configuration.getTemplates().get(name);
            MapAttribute map = null;
            for (Attribute attribute : template.getAttributes().values()) {
                if (!(attribute instanceof MapAttribute)) continue;
                if (map != null) {
                    throw new UnsupportedOperationException(String.format("Template '%s' contains more than one map configuration. The legacy API supports only one map per template.", name));
                }
                map = (MapAttribute)attribute;
            }
            if (map == null) {
                LOGGER.warn(String.format("Template '%s' contains no map configuration.", name));
            } else {
                MapAttribute.MapAttributeValues mapValues = map.createValue(template);
                json.key("map");
                json.object();
                json.key("width").value((long)mapValues.getMapSize().width);
                json.key("height").value((long)mapValues.getMapSize().height);
                json.endObject();
                if (maxDpi == null) {
                    maxDpi = map.getMaxDpi();
                    dpiSuggestions = map.getDpiSuggestions();
                }
                if (zoomLevels == null) {
                    zoomLevels = mapValues.getZoomLevels();
                }
            }
            json.endObject();
        }
        json.endArray();
        json.key("dpis");
        json.array();
        if (dpiSuggestions != null) {
            Iterator<String> iterator = dpiSuggestions;
            int name = ((Iterator<String>)iterator).length;
            for (int template = 0; template < name; ++template) {
                Double dpi = Double.valueOf(iterator[template]);
                json.object();
                json.key("name").value((Object)Integer.toString(dpi.intValue()));
                json.key("value").value((Object)Integer.toString(dpi.intValue()));
                json.endObject();
            }
        }
        json.endArray();
        json.key("scales");
        json.array();
        if (zoomLevels != null) {
            for (int i = 0; i < zoomLevels.size(); ++i) {
                Scale scale = zoomLevels.get(i, DistanceUnit.M);
                json.object();
                String scaleValue = new DecimalFormat("#.##").format(scale.getDenominator(72.0));
                json.key("name").value((Object)("1:" + scaleValue));
                json.key("value").value((Object)scaleValue);
                json.endObject();
            }
        }
        json.endArray();
    }

    private String getBaseUrl(String suffix, String baseUrl, HttpServletRequest req) {
        String urlToUseInSpec = !Strings.isNullOrEmpty((String)baseUrl) && baseUrl.endsWith(suffix) ? baseUrl.replace(suffix, DEP_SEG) : (!Strings.isNullOrEmpty((String)baseUrl) ? this.removeLastSlash(baseUrl) : this.removeLastSlash(super.getBaseUrl(req).toString()) + DEP_SEG);
        urlToUseInSpec = this.removeLastSlash(urlToUseInSpec);
        return urlToUseInSpec;
    }

    private String removeLastSlash(String urlToUseInSpec) {
        if (urlToUseInSpec.endsWith("/")) {
            return urlToUseInSpec.substring(1);
        }
        return urlToUseInSpec;
    }

    private String doCreatePDFFile(String spec, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException, InterruptedException, NoSuchAppException, NoSuchReferenceException {
        LOGGER.debug("\nOLD-API:\n{}", (Object)spec);
        PJsonObject specJson = MapPrinterServlet.parseJson(spec, httpServletResponse);
        String appId = specJson.has("app") ? specJson.getString("app") : "default";
        MapPrinter mapPrinter = this.printerFactory.create(appId);
        PJsonObject updatedSpecJson = null;
        try {
            updatedSpecJson = OldAPIRequestConverter.convert(specJson, mapPrinter.getConfiguration());
            String format = updatedSpecJson.optString("outputFormat", "pdf");
            String jobReferenceId = this.primaryApiServlet.createAndSubmitPrintJob(appId, format, updatedSpecJson.getInternalObj().toString(), httpServletRequest, httpServletResponse);
            boolean isDone = false;
            while (!isDone) {
                Thread.sleep(500L);
                isDone = this.jobManager.getStatus(jobReferenceId).isDone();
            }
            return jobReferenceId;
        }
        catch (JSONException e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }
}

