/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.test.util;

import com.google.common.io.Files;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import org.apache.batik.transcoder.TranscoderException;
import org.mapfish.print.SvgUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageSimilarity {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageSimilarity.class);
    private static final boolean GENERATE_IN_SOURCE = true;
    private final BufferedImage expectedImage;
    private final BufferedImage maskImage;
    private final BufferedImage diffImage;
    private final File expectedPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageSimilarity(File expectedFile) throws IOException {
        this.expectedImage = expectedFile.exists() ? ImageIO.read(expectedFile) : null;
        this.expectedPath = new File(expectedFile.toString().replaceAll("/out/", "/src/").replaceAll("/build/classes/test/", "/src/test/resources/"));
        File maskFile = this.getRelatedFile("mask");
        if (maskFile.exists()) {
            this.maskImage = ImageIO.read(maskFile);
            assert (this.maskImage.getSampleModel().getNumBands() == 1);
        } else {
            this.maskImage = new BufferedImage(this.expectedImage.getWidth(), this.expectedImage.getHeight(), 10);
            Graphics2D graphics = this.maskImage.createGraphics();
            try {
                graphics.setBackground(new Color(255, 255, 255));
                graphics.clearRect(0, 0, this.expectedImage.getWidth(), this.expectedImage.getHeight());
            }
            finally {
                graphics.dispose();
            }
        }
        this.diffImage = new BufferedImage(this.expectedImage.getWidth(), this.expectedImage.getHeight(), 1);
    }

    private File getRelatedFile(String name) {
        String expectedFileName = this.expectedPath.getName();
        return new File(this.expectedPath.getParentFile(), expectedFileName.contains("expected") ? expectedFileName.replace("expected", name) : name + "-" + expectedFileName);
    }

    private double calcDistance(BufferedImage actual) {
        if (actual.getWidth() != this.expectedImage.getWidth()) {
            LOGGER.error("Not the same width (expected: {}, actual: {})", (Object)this.expectedImage.getWidth(), (Object)actual.getWidth());
            return Double.MAX_VALUE;
        }
        if (actual.getHeight() != this.expectedImage.getHeight()) {
            LOGGER.error("Not the same height (expected: {}, actual: {})", (Object)this.expectedImage.getHeight(), (Object)actual.getHeight());
            return Double.MAX_VALUE;
        }
        if (actual.getSampleModel().getNumBands() != this.expectedImage.getSampleModel().getNumBands()) {
            LOGGER.error("Not the same number of bands (expected: {}, actual: {})", (Object)this.expectedImage.getSampleModel().getNumBands(), (Object)actual.getSampleModel().getNumBands());
            return Double.MAX_VALUE;
        }
        double dist = 0.0;
        double[] expectedPixel = new double[this.expectedImage.getSampleModel().getNumBands()];
        double[] actualPixel = new double[this.expectedImage.getSampleModel().getNumBands()];
        int[] maskPixel = new int[1];
        RandomIter expectedIterator = RandomIterFactory.create((RenderedImage)this.expectedImage, null);
        RandomIter actualIterator = RandomIterFactory.create((RenderedImage)actual, null);
        RandomIter maskIterator = RandomIterFactory.create((RenderedImage)this.maskImage, null);
        Graphics2D diffGraphics = this.diffImage.createGraphics();
        for (int x = 0; x < actual.getWidth(); ++x) {
            for (int y = 0; y < actual.getHeight(); ++y) {
                expectedIterator.getPixel(x, y, expectedPixel);
                actualIterator.getPixel(x, y, actualPixel);
                maskIterator.getPixel(x, y, maskPixel);
                double squareDist = 0.0;
                for (int i = 0; i < this.expectedImage.getSampleModel().getNumBands(); ++i) {
                    double colorDist = expectedPixel[i] - actualPixel[i];
                    squareDist += colorDist * colorDist;
                }
                double pxDiff = Math.sqrt(squareDist) / Math.sqrt(this.expectedImage.getSampleModel().getNumBands()) * ((double)maskPixel[0] / 255.0);
                dist += pxDiff / 255.0;
                diffGraphics.setColor(new Color((int)Math.round(pxDiff), 0, 0));
                diffGraphics.drawRect(x, y, 1, 1);
            }
        }
        diffGraphics.dispose();
        dist = dist / (double)this.expectedImage.getWidth() / (double)this.expectedImage.getHeight() * 10000.0;
        LOGGER.debug("Current distance: {}", (Object)dist);
        return dist;
    }

    public void assertSimilarity(File actual) throws IOException {
        this.assertSimilarity(actual, 1.0);
    }

    public void assertSimilarity(byte[] graphicData, double maxDistance) throws IOException {
        this.assertSimilarity(ImageIO.read(new ByteArrayInputStream(graphicData)), maxDistance);
    }

    public void assertSimilarity(List<URI> graphicFiles, int width, int height, double maxDistance) throws IOException, TranscoderException {
        this.assertSimilarity(ImageSimilarity.mergeImages(graphicFiles, width, height), maxDistance);
    }

    public void assertSimilarity(URI svgFile, int width, int height, double maxDistance) throws IOException, TranscoderException {
        this.assertSimilarity(ImageSimilarity.convertFromSvg(svgFile, width, height), maxDistance);
    }

    public void assertSimilarity(JasperPrint jasperPrint, Integer page, double maxDistance) throws IOException, JRException {
        this.assertSimilarity(ImageSimilarity.exportReportToImage(jasperPrint, page), maxDistance);
    }

    public void assertSimilarity(File actualFile, double maxDistance) throws IOException {
        this.assertSimilarity(ImageIO.read(actualFile), maxDistance);
    }

    public void assertSimilarity(BufferedImage actualImage, double maxDistance) throws IOException {
        if (!this.expectedPath.exists()) {
            ImageIO.write((RenderedImage)actualImage, "png", this.expectedPath);
            throw new AssertionError((Object)("The expected file was missing and has been generated: " + this.expectedPath.getAbsolutePath()));
        }
        double distance = this.calcDistance(actualImage);
        if (distance > maxDistance) {
            File actualOutput = this.getRelatedFile("actual");
            ImageIO.write((RenderedImage)actualImage, "png", actualOutput);
            File diffOutput = this.getRelatedFile("diff");
            ImageIO.write((RenderedImage)this.diffImage, "png", diffOutput);
            throw new AssertionError((Object)String.format("similarity difference between images is: %s which is greater than the max distance of %s%nactual=%s%nexpected=%s", distance, maxDistance, actualOutput.getAbsolutePath(), this.expectedPath.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeUncompressedImage(BufferedImage image, String file) throws IOException {
        try (FileImageOutputStream out = null;){
            File parentFile = new File(file).getParentFile();
            Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("png");
            ImageWriter next = writers.next();
            ImageWriteParam param = next.getDefaultWriteParam();
            param.setCompressionMode(0);
            File outputFile = new File(parentFile, Files.getNameWithoutExtension((String)file) + ".png");
            out = new FileImageOutputStream(outputFile);
            next.setOutput(out);
            next.write(image);
        }
    }

    public static BufferedImage mergeImages(List<URI> graphicFiles, int width, int height) throws IOException, TranscoderException {
        if (graphicFiles.isEmpty()) {
            throw new IllegalArgumentException("no graphics given");
        }
        BufferedImage mergedImage = ImageSimilarity.loadGraphic(graphicFiles.get(0), width, height);
        Graphics g = mergedImage.getGraphics();
        for (int i = 1; i < graphicFiles.size(); ++i) {
            BufferedImage image = ImageSimilarity.loadGraphic(graphicFiles.get(i), width, height);
            g.drawImage(image, 0, 0, null);
        }
        g.dispose();
        return mergedImage;
    }

    private static BufferedImage loadGraphic(URI path, int width, int height) throws IOException, TranscoderException {
        File file = new File(path);
        if (file.getName().endsWith(".svg")) {
            return ImageSimilarity.convertFromSvg(path, width, height);
        }
        BufferedImage originalImage = ImageIO.read(file);
        BufferedImage resizedImage = new BufferedImage(width, height, originalImage.getType());
        Graphics2D g = resizedImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }

    public static BufferedImage convertFromSvg(URI svgFile, int width, int height) throws TranscoderException {
        return SvgUtil.convertFromSvg(svgFile, width, height);
    }

    public static BufferedImage exportReportToImage(JasperPrint jasperPrint, Integer page) throws JRException {
        BufferedImage pageImage = new BufferedImage(jasperPrint.getPageWidth(), jasperPrint.getPageHeight(), 1);
        JRGraphics2DExporter exporter = new JRGraphics2DExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
        output.setGraphics2D((Graphics2D)pageImage.getGraphics());
        exporter.setExporterOutput((ExporterOutput)output);
        SimpleGraphics2DReportConfiguration configuration = new SimpleGraphics2DReportConfiguration();
        configuration.setPageIndex(page);
        exporter.setConfiguration((ReportExportConfiguration)configuration);
        exporter.exportReport();
        return pageImage;
    }

    public static void main(String[] args) throws IOException {
        String path = "core/src/test/resources/map-data";
        File root = new File("core/src/test/resources/map-data");
        Iterable files = Files.fileTraverser().depthFirstPostOrder((Object)root);
        for (File file : files) {
            if (!Files.getFileExtension((String)file.getName()).equals("png")) continue;
            BufferedImage img = ImageIO.read(file);
            ImageSimilarity.writeUncompressedImage(img, file.getAbsolutePath());
        }
    }
}

