/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.http;

import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.HttpProxy;
import org.mapfish.print.http.MfClientHttpRequestFactoryImpl;
import org.mapfish.print.processor.http.matcher.MatchInfo;
import org.springframework.http.HttpMethod;

public final class MfRoutePlanner
extends DefaultRoutePlanner {
    public MfRoutePlanner() {
        super(null);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        URI uri;
        Configuration config = MfClientHttpRequestFactoryImpl.getCurrentConfiguration();
        if (config == null) {
            return null;
        }
        try {
            uri = new URI(request.getRequestLine().getUri());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpMethod method = HttpMethod.valueOf((String)request.getRequestLine().getMethod());
        List<HttpProxy> proxies = config.getProxies();
        for (HttpProxy proxy : proxies) {
            try {
                if (!proxy.matches(MatchInfo.fromUri(uri, method))) continue;
                return proxy.getHttpHost();
            }
            catch (MalformedURLException | SocketException | UnknownHostException e) {
                throw new HttpException(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

