/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.geom.AffineTransform;
import javax.annotation.Nonnull;
import org.geotools.data.FeatureSource;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.styling.Style;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.GridType;
import org.mapfish.print.map.geotools.grid.GridUtils;
import org.mapfish.print.map.geotools.grid.LabelPositionCollector;
import org.mapfish.print.map.geotools.grid.LineGridStyle;
import org.mapfish.print.map.geotools.grid.LinearCoordinateSequence;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.MathTransform;

final class LineGridStrategy
implements GridType.GridTypeStrategy {
    LineGridStrategy() {
    }

    @Override
    public Style defaultStyle(Template template, GridParam layerData) {
        return LineGridStyle.get(layerData);
    }

    @Override
    public FeatureSourceSupplier createFeatureSource(Template template, final GridParam layerData, final LabelPositionCollector labels) {
        return new FeatureSourceSupplier(){

            @Override
            @Nonnull
            public FeatureSource load(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext mapContext) {
                SimpleFeatureType featureType = GridUtils.createGridFeatureType(mapContext, LineString.class);
                SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
                DefaultFeatureCollection features = layerData.numberOfLines != null ? LineGridStrategy.this.createFeaturesFromNumberOfLines(mapContext, featureBuilder, layerData, labels) : LineGridStrategy.this.createFeaturesFromSpacing(mapContext, featureBuilder, layerData, labels);
                return new CollectionFeatureSource((SimpleFeatureCollection)features);
            }
        };
    }

    @Nonnull
    private DefaultFeatureCollection createFeaturesFromNumberOfLines(@Nonnull MapfishMapContext mapContext, @Nonnull SimpleFeatureBuilder featureBuilder, @Nonnull GridParam layerData, @Nonnull LabelPositionCollector labels) {
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        double xSpace = bounds.getWidth() / (double)(layerData.numberOfLines[0] + 1);
        double ySpace = bounds.getHeight() / (double)(layerData.numberOfLines[1] + 1);
        double minX = bounds.getMinimum(0) + xSpace;
        double minY = bounds.getMinimum(1) + ySpace;
        return this.sharedCreateFeatures(labels, featureBuilder, layerData, mapContext, xSpace, ySpace, minX, minY);
    }

    @Nonnull
    private DefaultFeatureCollection createFeaturesFromSpacing(@Nonnull MapfishMapContext mapContext, @Nonnull SimpleFeatureBuilder featureBuilder, @Nonnull GridParam layerData, @Nonnull LabelPositionCollector labels) {
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        double xSpace = layerData.spacing[0];
        double ySpace = layerData.spacing[1];
        double minX = GridUtils.calculateFirstLine(bounds, layerData, 0);
        double minY = GridUtils.calculateFirstLine(bounds, layerData, 1);
        return this.sharedCreateFeatures(labels, featureBuilder, layerData, mapContext, xSpace, ySpace, minX, minY);
    }

    private DefaultFeatureCollection sharedCreateFeatures(LabelPositionCollector labels, SimpleFeatureBuilder featureBuilder, GridParam layerData, MapfishMapContext mapContext, double xSpace, double ySpace, double minX, double minY) {
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedEnvelope bounds = mapContext.toReferencedEnvelope();
        CoordinateReferenceSystem mapCrs = bounds.getCoordinateReferenceSystem();
        String unit = layerData.calculateLabelUnit(mapCrs);
        MathTransform labelTransform = layerData.calculateLabelTransform(mapCrs);
        AxisDirection direction = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection();
        int numDimensions = bounds.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        Polygon rotatedBounds = GridUtils.calculateBounds(mapContext);
        AffineTransform worldToScreenTransform = GridUtils.getWorldToScreenTransform(mapContext);
        DefaultFeatureCollection features = new DefaultFeatureCollection();
        double pointSpacing = bounds.getSpan(1) / (double)layerData.pointsInLine;
        int i = 0;
        for (double x = minX; x < bounds.getMaxX(); x += xSpace) {
            SimpleFeature feature = this.createFeature(featureBuilder, geometryFactory, layerData, direction, numDimensions, pointSpacing, x, bounds.getMinimum(1), ++i, 1);
            features.add(feature);
            GridUtils.topBorderLabel(labels, geometryFactory, rotatedBounds, unit, x, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
            GridUtils.bottomBorderLabel(labels, geometryFactory, rotatedBounds, unit, x, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
        }
        pointSpacing = bounds.getSpan(0) / (double)layerData.pointsInLine;
        int j = 0;
        for (double y = minY; y < bounds.getMaxY(); y += ySpace) {
            SimpleFeature feature = this.createFeature(featureBuilder, geometryFactory, layerData, direction, numDimensions, pointSpacing, bounds.getMinimum(0), y, ++j, 0);
            features.add(feature);
            GridUtils.rightBorderLabel(labels, geometryFactory, rotatedBounds, unit, y, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
            GridUtils.leftBorderLabel(labels, geometryFactory, rotatedBounds, unit, y, worldToScreenTransform, labelTransform, layerData.getGridLabelFormat());
        }
        return features;
    }

    private SimpleFeature createFeature(SimpleFeatureBuilder featureBuilder, GeometryFactory geometryFactory, GridParam layerData, AxisDirection direction, int numDimensions, double spacing, double x, double y, int i, int ordinate) {
        featureBuilder.reset();
        int numPoints = layerData.pointsInLine + 1;
        LinearCoordinateSequence coordinateSequence = new LinearCoordinateSequence().setDimension(numDimensions).setOrigin(x, y).setVariableAxis(ordinate).setNumPoints(numPoints).setSpacing(spacing).setOrdinate0AxisDirection(direction);
        LineString geom = geometryFactory.createLineString((CoordinateSequence)coordinateSequence);
        featureBuilder.set("geom", (Object)geom);
        return featureBuilder.buildFeature("grid." + (ordinate == 1 ? (char)'x' : 'y') + "." + i);
    }
}

