/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.style;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.styling.Style;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;

public final class ParserPluginUtils {
    private ParserPluginUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Style> loadStyleAsURI(ClientHttpRequestFactory clientHttpRequestFactory, String styleRef, Function<byte[], Optional<Style>> loadFunction) throws IOException {
        byte[] input;
        HttpStatus statusCode;
        try (Closer closer = Closer.create();){
            URI uri;
            try {
                uri = new URI(styleRef);
            }
            catch (URISyntaxException e) {
                uri = new File(styleRef).toURI();
            }
            ClientHttpRequest request = clientHttpRequestFactory.createRequest(uri, HttpMethod.GET);
            ClientHttpResponse response = (ClientHttpResponse)closer.register((Closeable)request.execute());
            statusCode = response.getStatusCode();
            input = ByteStreams.toByteArray((InputStream)response.getBody());
        }
        if (statusCode == HttpStatus.OK) {
            return (Optional)loadFunction.apply((Object)input);
        }
        return Optional.absent();
    }
}

