/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.http;

import com.google.common.collect.Maps;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.AbstractMfClientHttpRequestFactoryWrapper;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.http.AbstractClientHttpRequestFactoryProcessor;
import org.mapfish.print.processor.http.ClientHttpFactoryProcessorParam;
import org.mapfish.print.processor.http.matcher.UriMatchers;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class AddHeadersProcessor
extends AbstractClientHttpRequestFactoryProcessor {
    private final Map<String, List<String>> headers = Maps.newHashMap();

    public void setHeaders(Map<String, Object> headers) {
        this.headers.clear();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            List<String> value;
            if (entry.getValue() instanceof List) {
                value = (List<String>)entry.getValue();
                for (Object e : value) {
                    Assert.isTrue((boolean)(e instanceof String), (String)(e + " is not a string it is a: '" + e.getClass() + "'"));
                }
                this.headers.put(entry.getKey(), (List)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof String) {
                value = Collections.singletonList((String)entry.getValue());
                this.headers.put(entry.getKey(), value);
                continue;
            }
            throw new IllegalArgumentException("Only strings and list of strings may be headers");
        }
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        super.extraValidation(validationErrors, configuration);
        if (this.headers.isEmpty()) {
            validationErrors.add(new IllegalStateException("There are no headers defined."));
        }
    }

    @Override
    public MfClientHttpRequestFactory createFactoryWrapper(ClientHttpFactoryProcessorParam clientHttpFactoryProcessorParam, MfClientHttpRequestFactory requestFactory) {
        return AddHeadersProcessor.createFactoryWrapper(requestFactory, this.matchers, this.headers);
    }

    public static MfClientHttpRequestFactory createFactoryWrapper(MfClientHttpRequestFactory requestFactory, UriMatchers matchers, final Map<String, List<String>> headers) {
        return new AbstractMfClientHttpRequestFactoryWrapper(requestFactory, matchers, false){

            @Override
            protected ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod, MfClientHttpRequestFactory requestFactory) throws IOException {
                ClientHttpRequest request = requestFactory.createRequest(uri, httpMethod);
                request.getHeaders().putAll(headers);
                return request;
            }
        };
    }
}

