/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.processor.jasper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.json.JSONObject;
import org.mapfish.print.Constants;
import org.mapfish.print.PrintException;
import org.mapfish.print.attribute.TableAttribute;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.config.ConfigurationException;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.processor.AbstractProcessor;
import org.mapfish.print.processor.Processor;
import org.mapfish.print.processor.http.MfClientHttpRequestFactoryProvider;
import org.mapfish.print.processor.jasper.JasperReportBuilder;
import org.mapfish.print.processor.jasper.TableColumnConverter;
import org.mapfish.print.wrapper.PArray;
import org.springframework.beans.factory.annotation.Autowired;

public final class TableProcessor
extends AbstractProcessor<Input, Output> {
    private static final int SPACE_BETWEEN_COLS = 0;
    private static final int DEFAULT_MAX_COLUMNS = 9;
    private Map<String, TableColumnConverter<?>> columnConverterMap = Maps.newHashMap();
    private List<TableColumnConverter<?>> converters = Lists.newArrayList();
    private boolean dynamic = false;
    private Integer reportWidth = null;
    private String jasperTemplate = null;
    private String firstHeaderStyle;
    private String lastHeaderStyle;
    private String headerStyle;
    private String firstDetailStyle;
    private String lastDetailStyle;
    private String detailStyle;
    private int maxColumns = 9;
    private Set<String> excludeColumns = Sets.newHashSet();
    @Autowired
    private JasperReportBuilder jasperReportBuilder;
    private boolean defaultTemplate;

    protected TableProcessor() {
        super(Output.class);
    }

    public void setJasperTemplate(String jasperTemplate) {
        this.jasperTemplate = jasperTemplate;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setReportWidth(Integer reportWidth) {
        this.reportWidth = reportWidth;
    }

    public void setColumns(Map<String, TableColumnConverter<?>> columnConverters) {
        this.columnConverterMap = columnConverters;
    }

    public void setConverters(List<TableColumnConverter<?>> converters) {
        this.converters = converters;
    }

    public void setFirstHeaderStyle(String firstHeaderStyle) {
        this.firstHeaderStyle = firstHeaderStyle;
    }

    public void setLastHeaderStyle(String lastHeaderStyle) {
        this.lastHeaderStyle = lastHeaderStyle;
    }

    public void setHeaderStyle(String headerStyle) {
        this.headerStyle = headerStyle;
    }

    public void setFirstDetailStyle(String firstDetailStyle) {
        this.firstDetailStyle = firstDetailStyle;
    }

    public void setLastDetailStyle(String lastDetailStyle) {
        this.lastDetailStyle = lastDetailStyle;
    }

    public void setDetailStyle(String detailStyle) {
        this.detailStyle = detailStyle;
    }

    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    public void setExcludeColumns(Set<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    @Override
    public Input createInputParameter() {
        return new Input();
    }

    @Override
    public Output execute(Input values, Processor.ExecutionContext context) throws Exception {
        PArray[] jsonData;
        TableAttribute.TableAttributeValue jsonTable = values.table;
        ArrayList table = new ArrayList();
        String[] columnNames = jsonTable.columns;
        LinkedHashMap columns = Maps.newLinkedHashMap();
        for (PArray jsonRow : jsonData = jsonTable.data) {
            this.checkCancelState(context);
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int j = 0; j < jsonRow.size(); ++j) {
                Class columnDef;
                TableColumnConverter<?> converter;
                String columnName = columnNames[j];
                Object rowValue = jsonRow.get(j);
                if (rowValue == JSONObject.NULL) {
                    rowValue = null;
                }
                rowValue = (converter = this.columnConverterMap.get(columnName)) != null ? converter.resolve(values.clientHttpRequestFactoryProvider.get(), (String)rowValue) : this.tryConvert(values.clientHttpRequestFactoryProvider.get(), rowValue);
                if (columns.size() < this.maxColumns && !this.excludeColumns.contains(columnName) && (columnDef = (Class)columns.get(columnName)) == null) {
                    Class<?> rowValueClass = null;
                    if (rowValue != null) {
                        rowValueClass = rowValue.getClass();
                    }
                    columns.put(columnName, rowValueClass);
                }
                row.put(columnName, rowValue);
            }
            table.add(row);
        }
        String subreport = null;
        if (this.dynamic) {
            subreport = this.generateSubReport(values, columns);
        }
        JRMapCollectionDataSource dataSource = new JRMapCollectionDataSource(table);
        return new Output(dataSource, table.size(), subreport);
    }

    private Object tryConvert(MfClientHttpRequestFactory clientHttpRequestFactory, Object rowValue) throws URISyntaxException, IOException {
        if (this.converters.isEmpty()) {
            return rowValue;
        }
        String value = String.valueOf(rowValue);
        for (TableColumnConverter<?> converter : this.converters) {
            if (!converter.canConvert(value)) continue;
            return converter.resolve(clientHttpRequestFactory, value);
        }
        return rowValue;
    }

    private String generateSubReport(Input input, Map<String, Class<?>> columns) throws JRException, ClassNotFoundException, IOException {
        byte[] bytes = this.loadJasperTemplate(input.template.getConfiguration());
        JasperDesign templateDesign = JRXmlLoader.load((InputStream)new ByteArrayInputStream(bytes));
        if (this.reportWidth != null) {
            templateDesign.setPageWidth(this.reportWidth.intValue());
        }
        int headerHeight = templateDesign.getColumnHeader().getHeight();
        JRDesignSection detailSection = (JRDesignSection)templateDesign.getDetailSection();
        int detailHeight = detailSection.getBands()[0].getHeight();
        JRElement sampleHeaderEl = templateDesign.getColumnHeader().getElements()[0];
        int headerPosX = sampleHeaderEl.getX();
        int headerPosY = sampleHeaderEl.getY();
        JRElement sampleDetailEl = detailSection.getBands()[0].getElements()[0];
        int detailPosX = sampleDetailEl.getX();
        int detailPosY = sampleDetailEl.getY();
        this.clearFields(templateDesign);
        this.removeDetailBand(templateDesign);
        JRDesignBand headerBand = new JRDesignBand();
        headerBand.setHeight(headerHeight);
        templateDesign.setColumnHeader((JRBand)headerBand);
        JRDesignBand detailBand = new JRDesignBand();
        detailBand.setHeight(detailHeight);
        detailSection.addBand((JRBand)detailBand);
        int numColumns = columns.size();
        int columnWidth = columns.isEmpty() ? templateDesign.getPageWidth() : (templateDesign.getPageWidth() - 0 * (numColumns - 1)) / numColumns;
        int i = 0;
        for (Map.Entry<String, Class<?>> entry : columns.entrySet()) {
            JRStyle columnHeaderStyle;
            JRStyle columnDetailStyle;
            if (++i == 1) {
                columnDetailStyle = this.getStyle(templateDesign, this.firstDetailStyle, this.detailStyle);
                columnHeaderStyle = this.getStyle(templateDesign, this.firstHeaderStyle, this.headerStyle);
            } else if (i == numColumns) {
                columnDetailStyle = this.getStyle(templateDesign, this.lastDetailStyle, this.detailStyle);
                columnHeaderStyle = this.getStyle(templateDesign, this.lastHeaderStyle, this.headerStyle);
            } else {
                columnDetailStyle = (JRStyle)templateDesign.getStylesMap().get(this.detailStyle);
                columnHeaderStyle = (JRStyle)templateDesign.getStylesMap().get(this.headerStyle);
            }
            String columnName = entry.getKey();
            Class valueClass = String.class;
            if (entry.getValue() != null) {
                valueClass = entry.getValue();
            }
            JRDesignField field = new JRDesignField();
            field.setName(columnName);
            if (this.converters.isEmpty()) {
                field.setValueClass(valueClass);
            } else {
                field.setValueClass(Object.class);
            }
            templateDesign.addField((JRField)field);
            JRDesignTextField colHeaderField = new JRDesignTextField();
            colHeaderField.setX(headerPosX);
            colHeaderField.setY(headerPosY);
            colHeaderField.setWidth(columnWidth);
            colHeaderField.setHeight(headerHeight);
            colHeaderField.setHorizontalTextAlign(HorizontalTextAlignEnum.LEFT);
            colHeaderField.setStyle(columnHeaderStyle);
            colHeaderField.setStretchWithOverflow(true);
            colHeaderField.setStretchType(StretchTypeEnum.ELEMENT_GROUP_HEIGHT);
            JRDesignExpression headerExpression = new JRDesignExpression();
            headerExpression.setText('\"' + columnName + '\"');
            colHeaderField.setExpression((JRExpression)headerExpression);
            headerBand.addElement((JRDesignElement)colHeaderField);
            if (this.converters.isEmpty()) {
                if (RenderedImage.class.isAssignableFrom(valueClass)) {
                    JRDesignElement designElement = this.createImageElement(templateDesign, columnName);
                    this.addElement(detailBand, designElement, detailPosX, detailPosY, columnWidth, detailHeight, columnDetailStyle);
                } else {
                    JRDesignTextField textField = this.createTextField(columnName);
                    this.addElement(detailBand, (JRDesignElement)textField, detailPosX, detailPosY, columnWidth, detailHeight, columnDetailStyle);
                }
            } else {
                JRDesignElement imageElement = this.createImageElement(templateDesign, columnName);
                JRDesignExpression printWhenExpression = new JRDesignExpression();
                printWhenExpression.setText("new Boolean($F{" + columnName + "}.getClass().equals(java.awt.image.BufferedImage.class))");
                imageElement.setPrintWhenExpression((JRExpression)printWhenExpression);
                this.addElement(detailBand, imageElement, detailPosX, detailPosY, columnWidth, detailHeight, columnDetailStyle);
                JRDesignTextField textField = this.createTextField(columnName);
                printWhenExpression = new JRDesignExpression();
                printWhenExpression.setText("new Boolean(!$F{" + columnName + "}.getClass().equals(java.awt.image.BufferedImage.class))");
                textField.setPrintWhenExpression((JRExpression)printWhenExpression);
                this.addElement(detailBand, (JRDesignElement)textField, detailPosX, detailPosY, columnWidth, detailHeight, columnDetailStyle);
            }
            headerPosX = headerPosX + columnWidth + 0;
            detailPosX = detailPosX + columnWidth + 0;
        }
        File jrxmlFile = File.createTempFile("table-", ".jrxml", input.tempTaskDirectory);
        JRXmlWriter.writeReport((JRReport)templateDesign, (String)jrxmlFile.getAbsolutePath(), (String)Constants.DEFAULT_ENCODING);
        File buildFile = File.createTempFile("table-", ".jasper", input.tempTaskDirectory);
        if (!buildFile.delete()) {
            throw new PrintException("Unable to delete the build file: " + buildFile);
        }
        return this.jasperReportBuilder.compileJasperReport(buildFile, jrxmlFile).getAbsolutePath();
    }

    private JRDesignTextField createTextField(String columnName) {
        JRDesignTextField textField = new JRDesignTextField();
        textField.setHorizontalTextAlign(HorizontalTextAlignEnum.LEFT);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setText("$F{" + columnName + "}");
        textField.setExpression((JRExpression)expression);
        textField.setStretchWithOverflow(true);
        return textField;
    }

    private JRDesignElement createImageElement(JasperDesign templateDesign, String columnName) {
        JRDesignImage designImage = new JRDesignImage((JRDefaultStyleProvider)templateDesign);
        designImage.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        designImage.setHorizontalImageAlign(HorizontalImageAlignEnum.LEFT);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setText("$F{" + columnName + "}");
        designImage.setExpression((JRExpression)expression);
        return designImage;
    }

    private void addElement(JRDesignBand detailBand, JRDesignElement designElement, int detailPosX, int detailPosY, int columnWidth, int detailHeight, JRStyle columnDetailStyle) {
        designElement.setStretchType(StretchTypeEnum.ELEMENT_GROUP_HEIGHT);
        designElement.setX(detailPosX);
        designElement.setY(detailPosY);
        designElement.setWidth(columnWidth);
        designElement.setHeight(detailHeight);
        designElement.setStyle(columnDetailStyle);
        detailBand.addElement(designElement);
    }

    private void removeDetailBand(JasperDesign templateDesign) {
        JRDesignSection detailSection = (JRDesignSection)templateDesign.getDetailSection();
        ArrayList bandsList = Lists.newArrayList((Iterable)detailSection.getBandsList());
        for (JRBand jrBand : bandsList) {
            detailSection.removeBand(jrBand);
        }
    }

    private void clearFields(JasperDesign templateDesign) {
        ArrayList fieldsList = Lists.newArrayList((Iterable)templateDesign.getFieldsList());
        for (JRField jrField : fieldsList) {
            templateDesign.removeField(jrField);
        }
    }

    private JRStyle getStyle(JasperDesign templateDesign, String specificStyle, String defaultStyle) {
        JRStyle columnDetailStyle = specificStyle != null ? (JRStyle)templateDesign.getStylesMap().get(specificStyle) : (JRStyle)templateDesign.getStylesMap().get(defaultStyle);
        return columnDetailStyle;
    }

    @Override
    protected void extraValidation(List<Throwable> validationErrors, Configuration configuration) {
        boolean styleRefDeclared;
        boolean bl = styleRefDeclared = this.firstHeaderStyle != null || this.lastHeaderStyle != null || this.headerStyle != null || this.firstDetailStyle != null || this.lastDetailStyle != null || this.detailStyle != null;
        if (styleRefDeclared && this.jasperTemplate == null) {
            validationErrors.add(new ConfigurationException("if a style is declared a 'jasperTemplate' must also be declared (in !tableProcessor)."));
        }
        if (styleRefDeclared && !this.dynamic) {
            validationErrors.add(new ConfigurationException("if a style is declared dynamic must be true (in !tableProcessor)."));
        }
        if (this.dynamic) {
            if (this.jasperTemplate == null) {
                try {
                    this.jasperTemplate = TableProcessor.class.getResource("dynamic-table-default.jrxml").toURI().toString();
                    this.firstDetailStyle = "column_style_1";
                    this.detailStyle = "column_style_2";
                    this.lastDetailStyle = "column_style_3";
                    this.firstHeaderStyle = "header_style_1";
                    this.headerStyle = "header_style_2";
                    this.lastHeaderStyle = "header_style_3";
                    this.defaultTemplate = true;
                }
                catch (URISyntaxException e) {
                    throw new Error(e);
                }
            }
            if (this.headerStyle == null) {
                validationErrors.add(new ConfigurationException("'headerStyle' property must be declared if !tableProcessor is dynamic."));
            }
            if (this.detailStyle == null) {
                validationErrors.add(new ConfigurationException("'detailStyle' property must be declared if !tableProcessor is dynamic."));
            }
            try {
                byte[] bytes = this.loadJasperTemplate(configuration);
                JasperDesign templateDesign = JRXmlLoader.load((InputStream)new ByteArrayInputStream(bytes));
                Map stylesMap = templateDesign.getStylesMap();
                if (templateDesign.getColumnHeader() == null) {
                    validationErrors.add(new ConfigurationException("JasperTemplate must have a column band defined for height and positioning information"));
                } else if (templateDesign.getColumnHeader().getElements().length == 0) {
                    validationErrors.add(new ConfigurationException("column header band must have at least one element defined for to height and positioning information"));
                }
                JRDesignSection detailSection = (JRDesignSection)templateDesign.getDetailSection();
                if (detailSection.getBands().length == 0) {
                    validationErrors.add(new ConfigurationException("JasperTemplate must have a detail band defined for height and positioning information"));
                } else if (detailSection.getBands()[0].getElements().length == 0) {
                    validationErrors.add(new ConfigurationException("detail band must have at least one element defined for to height and positioning information"));
                }
                this.checkStyleExists(validationErrors, stylesMap, this.firstDetailStyle);
                this.checkStyleExists(validationErrors, stylesMap, this.detailStyle);
                this.checkStyleExists(validationErrors, stylesMap, this.lastDetailStyle);
                this.checkStyleExists(validationErrors, stylesMap, this.firstHeaderStyle);
                this.checkStyleExists(validationErrors, stylesMap, this.headerStyle);
                this.checkStyleExists(validationErrors, stylesMap, this.lastHeaderStyle);
            }
            catch (Throwable e) {
                validationErrors.add(e);
            }
        }
    }

    private byte[] loadJasperTemplate(Configuration configuration) throws IOException {
        if (this.defaultTemplate) {
            return Resources.toByteArray((URL)new URL(this.jasperTemplate));
        }
        return configuration.loadFile(this.jasperTemplate);
    }

    private void checkStyleExists(List<Throwable> validationErrors, Map<String, JRStyle> stylesMap, String styleRef) {
        if (styleRef != null && !stylesMap.containsKey(styleRef)) {
            validationErrors.add(new ConfigurationException("No style with id: '" + styleRef + "' exists in " + this.jasperTemplate));
        }
    }

    public static final class Output {
        public final JRMapCollectionDataSource tableDataSource;
        public final int numberOfTableRows;
        public final String tableSubReport;

        private Output(JRMapCollectionDataSource dataSource, int numberOfTableRows, String subReport) {
            this.tableDataSource = dataSource;
            this.numberOfTableRows = numberOfTableRows;
            this.tableSubReport = subReport;
        }
    }

    public static final class Input {
        public MfClientHttpRequestFactoryProvider clientHttpRequestFactoryProvider;
        public File tempTaskDirectory;
        public Template template;
        public TableAttribute.TableAttributeValue table;
    }
}

