/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.image.wms;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.io.Closer;
import com.vividsolutions.jts.util.Assert;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.HttpRequestCache;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.image.AbstractSingleImageLayer;
import org.mapfish.print.map.image.wms.WmsLayerParam;
import org.mapfish.print.map.image.wms.WmsUtilities;
import org.mapfish.print.map.style.json.ColorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class WmsLayer
extends AbstractSingleImageLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmsLayer.class);
    private final WmsLayerParam params;
    private final MetricRegistry registry;
    private final Configuration configuration;
    private ClientHttpRequest imageRequest;

    protected WmsLayer(@Nonnull ExecutorService executorService, @Nonnull StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull WmsLayerParam params, @Nonnull MetricRegistry registry, @Nonnull Configuration configuration) {
        super(executorService, styleSupplier, params);
        this.params = params;
        this.registry = registry;
        this.configuration = configuration;
    }

    @Override
    protected BufferedImage loadImage(@Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext transformer) throws Throwable {
        String baseMetricName = WmsLayer.class.getName() + ".read." + this.imageRequest.getURI().getHost();
        try (Closer closer = Closer.create();){
            Timer.Context timerDownload = this.registry.timer(baseMetricName).time();
            LOGGER.info("Query the WMS image {}.", (Object)this.imageRequest.getURI());
            ClientHttpResponse response = (ClientHttpResponse)closer.register((Closeable)this.imageRequest.execute());
            Assert.isTrue((response != null ? 1 : 0) != 0, (String)"No response, see error above");
            Assert.equals((Object)HttpStatus.OK, (Object)response.getStatusCode(), (String)String.format("Http status code for %s was not OK.  It was: %s. The response message was: '%s'", this.imageRequest.getURI(), response.getStatusCode(), response.getStatusText()));
            List contentType = response.getHeaders().get((Object)"Content-Type");
            if (contentType == null || contentType.size() != 1) {
                LOGGER.debug("The WMS image {} don't return a valid content type header.", (Object)this.imageRequest.getURI());
            } else if (!((String)contentType.get(0)).startsWith("image/")) {
                byte[] data = new byte[response.getBody().available()];
                response.getBody().read(data);
                LOGGER.debug("We get a wrong WMS image for {}, content type: {}\nresult:\n{}", new Object[]{this.imageRequest.getURI(), contentType.get(0), new String(data, "UTF-8")});
                this.registry.counter(baseMetricName + ".error").inc();
                BufferedImage bufferedImage = this.createErrorImage(transformer.getPaintArea());
                return bufferedImage;
            }
            BufferedImage image = ImageIO.read(response.getBody());
            if (image == null) {
                LOGGER.warn("The WMS image {} is an image format that can be decoded", (Object)this.imageRequest.getURI());
                this.registry.counter(baseMetricName + ".error").inc();
                BufferedImage bufferedImage = this.createErrorImage(transformer.getPaintArea());
                return bufferedImage;
            }
            timerDownload.stop();
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createErrorImage(Rectangle area) {
        BufferedImage bufferedImage = new BufferedImage(area.width, area.height, 3);
        Graphics2D graphics = bufferedImage.createGraphics();
        try {
            graphics.setBackground(ColorParser.toColor(this.configuration.getTransparentTileErrorColor()));
            graphics.clearRect(0, 0, area.width, area.height);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
        finally {
            graphics.dispose();
        }
    }

    public WmsLayerParam getParams() {
        return this.params;
    }

    @Override
    public boolean supportsNativeRotation() {
        return this.params.useNativeAngle && (this.params.serverType == WmsLayerParam.ServerType.MAPSERVER || this.params.serverType == WmsLayerParam.ServerType.GEOSERVER);
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.fromMimeType(this.params.imageFormat);
    }

    @Override
    public void cacheResources(@Nonnull HttpRequestCache httpRequestCache, @Nonnull MfClientHttpRequestFactory requestFactory, @Nonnull MapfishMapContext transformer, @Nonnull String jobId) {
        try {
            MapfishMapContext layerTransformer = this.getLayerTransformer(transformer);
            WmsLayerParam wmsLayerParam = this.params;
            URI commonUri = new URI(wmsLayerParam.getBaseUrl());
            Rectangle paintArea = layerTransformer.getPaintArea();
            ReferencedEnvelope envelope = layerTransformer.getBounds().toReferencedEnvelope(paintArea);
            URI uri = WmsUtilities.makeWmsGetLayerRequest(wmsLayerParam, commonUri, paintArea.getSize(), layerTransformer.getDPI(), layerTransformer.getRotation(), envelope);
            this.imageRequest = httpRequestCache.register(requestFactory, uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

