/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.parser;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.vividsolutions.jts.util.Assert;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.mapfish.print.parser.Requires;

class RequiresTracker {
    private Multimap<Field, String> dependantToRequirementsMap = HashMultimap.create();
    private Map<String, Field> requirementToDependantMap = Maps.newHashMap();
    private Collection<Field> dependantsInJson = Lists.newArrayList();

    RequiresTracker() {
    }

    public void register(Field field) {
        Requires requires = field.getAnnotation(Requires.class);
        if (requires != null) {
            String[] requirements;
            for (String requirement : requirements = requires.value()) {
                this.dependantToRequirementsMap.put((Object)field, (Object)requirement);
                this.requirementToDependantMap.put(requirement, field);
            }
        }
    }

    public void markAsVisited(Field field) {
        Field dependant;
        if (field.getAnnotation(Requires.class) != null) {
            this.dependantsInJson.add(field);
        }
        if ((dependant = this.requirementToDependantMap.get(field.getName())) != null) {
            this.dependantToRequirementsMap.remove((Object)dependant, (Object)field.getName());
        }
    }

    public void checkAllRequirementsSatisfied(String currentPath) {
        StringBuilder errors = new StringBuilder();
        for (Field field : this.dependantsInJson) {
            Collection requirements = this.dependantToRequirementsMap.get((Object)field);
            if (requirements.isEmpty()) continue;
            errors.append("\n");
            String type = field.getType().getName();
            if (field.getType().isArray()) {
                type = field.getType().getComponentType().getName() + "[]";
            }
            errors.append("\t* ").append(type).append(' ').append(field.getName()).append(" depends on ").append(requirements);
        }
        Assert.equals((Object)0, (Object)errors.length(), (String)("\nErrors were detected when analysing the @Requires dependencies of '" + currentPath + "': " + errors));
    }
}

