/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import org.geotools.data.FeatureSource;
import org.geotools.map.Layer;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.MapfishMapContext;
import org.mapfish.print.http.HttpRequestCache;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayer;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.geotools.grid.GridLabel;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.LabelPositionCollector;
import org.mapfish.print.map.geotools.grid.RotationQuadrant;
import org.mapfish.print.map.style.json.ColorParser;

public final class GridLayer
implements MapLayer {
    private final GridParam params;
    private final LabelPositionCollector labels;
    AbstractFeatureSourceLayer grid;

    public GridLayer(ExecutorService executorService, FeatureSourceSupplier featureSourceSupplier, StyleSupplier<FeatureSource> styleSupplier, boolean renderAsSvg, GridParam params, LabelPositionCollector labels) {
        this.grid = new AbstractFeatureSourceLayer(executorService, featureSourceSupplier, styleSupplier, renderAsSvg, params){};
        this.params = params;
        this.labels = labels;
    }

    @Override
    public Optional<MapLayer> tryAddLayer(MapLayer newLayer) {
        return Optional.absent();
    }

    @Override
    public double getImageBufferScaling() {
        return 1.0;
    }

    @Override
    public void prepareRender(MapfishMapContext transformer) {
    }

    @Override
    public void render(Graphics2D graphics, MfClientHttpRequestFactory clientHttpRequestFactory, MapfishMapContext transformer, String jobId) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        float haloRadius = (float)this.params.haloRadius;
        double dpiScaling = transformer.getDPI() / 72.0;
        this.grid.render(graphics2D, clientHttpRequestFactory, transformer, jobId);
        Font baseFont = null;
        for (String fontName : this.params.font.name) {
            try {
                baseFont = new Font(fontName, this.params.font.style.styleId, (int)((double)this.params.font.size * dpiScaling));
                break;
            }
            catch (Exception exception) {
            }
        }
        graphics2D.setFont(baseFont);
        int halfCharHeight = graphics2D.getFontMetrics().getAscent() / 2;
        Stroke baseStroke = graphics2D.getStroke();
        AffineTransform baseTransform = graphics2D.getTransform();
        Color haloColor = ColorParser.toColor(this.params.haloColor);
        Color labelColor = ColorParser.toColor(this.params.labelColor);
        for (GridLabel label : this.labels) {
            Shape textShape = baseFont.createGlyphVector(graphics2D.getFontRenderContext(), label.text).getOutline();
            Rectangle2D textBounds = textShape.getBounds2D();
            AffineTransform transform = new AffineTransform(baseTransform);
            transform.translate(label.x, label.y);
            this.applyOffset(transform, label.side);
            RotationQuadrant.getQuadrant(transformer.getRotation(), this.params.rotateLabels).updateTransform(transform, this.params.indent, label.side, halfCharHeight, textBounds);
            graphics2D.setTransform(transform);
            if (haloRadius > 0.0f) {
                graphics2D.setStroke(new BasicStroke(2.0f * haloRadius, 1, 1));
                graphics2D.setColor(haloColor);
                graphics2D.draw(textShape);
            }
            graphics2D.setStroke(baseStroke);
            graphics2D.setColor(labelColor);
            graphics2D.fill(textShape);
        }
    }

    private void applyOffset(AffineTransform transform, GridLabel.Side side) {
        switch (side) {
            case BOTTOM: 
            case TOP: {
                transform.translate(this.params.verticalXOffset, 0.0);
                break;
            }
            default: {
                transform.translate(0.0, this.params.horizontalYOffset);
            }
        }
    }

    @Override
    public boolean supportsNativeRotation() {
        return true;
    }

    @Override
    public String getName() {
        return this.params.name;
    }

    @VisibleForTesting
    List<? extends Layer> getLayers(@Nonnull MfClientHttpRequestFactory httpRequestFactory, @Nonnull MapfishMapContext mapContext, @Nonnull String jobId) throws Exception {
        return this.grid.getLayers(httpRequestFactory, mapContext, jobId);
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return this.grid.getRenderType();
    }

    @Override
    public void cacheResources(HttpRequestCache httpRequestCache, MfClientHttpRequestFactory clientHttpRequestFactory, MapfishMapContext transformer, String jobId) {
        this.grid.cacheResources(httpRequestCache, clientHttpRequestFactory, transformer, jobId);
    }

    @Override
    public double getOpacity() {
        return this.params.opacity;
    }
}

