/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import org.geotools.data.FeatureSource;
import org.geotools.styling.Style;
import org.mapfish.print.config.Template;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.AbstractFeatureSourceLayerPlugin;
import org.mapfish.print.map.geotools.FeatureSourceSupplier;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.geotools.grid.GridLayer;
import org.mapfish.print.map.geotools.grid.GridParam;
import org.mapfish.print.map.geotools.grid.LabelPositionCollector;
import org.springframework.beans.factory.annotation.Autowired;

public final class GridLayerPlugin
extends AbstractFeatureSourceLayerPlugin<GridParam> {
    private static final String TYPE = "grid";
    @Autowired
    private ForkJoinPool pool;

    public GridLayerPlugin() {
        super(TYPE, new String[0]);
    }

    @Override
    public GridParam createParameter() {
        return new GridParam();
    }

    @Nonnull
    public GridLayer parse(@Nonnull Template template, @Nonnull GridParam layerData) {
        LabelPositionCollector labels = new LabelPositionCollector();
        FeatureSourceSupplier featureSource = this.createFeatureSourceFunction(template, layerData, labels);
        StyleSupplier<FeatureSource> styleFunction = this.createStyleSupplier(template, layerData);
        return new GridLayer(this.pool, featureSource, styleFunction, template.getConfiguration().renderAsSvg(layerData.renderAsSvg), layerData, labels);
    }

    private StyleSupplier<FeatureSource> createStyleSupplier(final Template template, final GridParam layerData) {
        return new StyleSupplier<FeatureSource>(){

            @Override
            public Style load(MfClientHttpRequestFactory requestFactory, FeatureSource featureSource) {
                String styleRef = layerData.style;
                return (Style)template.getStyle(styleRef).or(GridLayerPlugin.this.parser.loadStyle(template.getConfiguration(), requestFactory, styleRef)).or((Object)layerData.gridType.strategy.defaultStyle(template, layerData));
            }
        };
    }

    private FeatureSourceSupplier createFeatureSourceFunction(Template template, GridParam layerData, LabelPositionCollector labels) {
        return layerData.gridType.strategy.createFeatureSource(template, layerData, labels);
    }
}

