/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.concurrent.Callable;
import java.util.concurrent.RecursiveTask;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.map.style.json.ColorParser;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.TilePreparationInfo;
import org.mapfish.print.map.tiled.TilePreparationTask;
import org.opengis.geometry.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

public final class CoverageTask
implements Callable<GridCoverage2D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoverageTask.class);
    private final TileCacheInformation tiledLayer;
    private final TilePreparationInfo tilePreparationInfo;
    private final boolean failOnError;
    private final MetricRegistry registry;
    private final String jobId;
    private final BufferedImage errorImage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageTask(@Nonnull TilePreparationInfo tilePreparationInfo, boolean failOnError, @Nonnull MetricRegistry registry, @Nonnull String jobId, @Nonnull TileCacheInformation tileCacheInfo, @Nonnull Configuration configuration) {
        this.tilePreparationInfo = tilePreparationInfo;
        this.jobId = jobId;
        this.tiledLayer = tileCacheInfo;
        this.failOnError = failOnError;
        this.registry = registry;
        Dimension tileSize = this.tiledLayer.getTileSize();
        this.errorImage = new BufferedImage(tileSize.width, tileSize.height, 6);
        Graphics2D graphics = this.errorImage.createGraphics();
        try {
            graphics.setBackground(ColorParser.toColor(configuration.getOpaqueTileErrorColor()));
            graphics.clearRect(0, 0, tileSize.width, tileSize.height);
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    public GridCoverage2D call() {
        try {
            BufferedImage coverageImage = this.tiledLayer.createBufferedImage(this.tilePreparationInfo.getImageWidth(), this.tilePreparationInfo.getImageHeight());
            Graphics2D graphics = coverageImage.createGraphics();
            for (TilePreparationInfo.SingleTilePreparationInfo tileInfo : this.tilePreparationInfo.getSingleTiles()) {
                TileTask task = tileInfo.getTileRequest() != null ? new SingleTileLoaderTask(tileInfo.getTileRequest(), this.errorImage, tileInfo.getTileIndexX(), tileInfo.getTileIndexY(), this.failOnError, this.registry, this.jobId) : new PlaceHolderImageTask(this.tiledLayer.getMissingTileImage(), tileInfo.getTileIndexX(), tileInfo.getTileIndexY());
                Tile tile = task.call();
                if (tile.getImage() == null) continue;
                graphics.drawImage((Image)tile.getImage(), tile.getxIndex() * this.tiledLayer.getTileSize().width, tile.getyIndex() * this.tiledLayer.getTileSize().height, null);
            }
            graphics.dispose();
            GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
            GeneralEnvelope gridEnvelope = new GeneralEnvelope(this.tilePreparationInfo.getMapProjection());
            gridEnvelope.setEnvelope(new double[]{this.tilePreparationInfo.getGridCoverageOrigin().x, this.tilePreparationInfo.getGridCoverageOrigin().y, this.tilePreparationInfo.getGridCoverageMaxX(), this.tilePreparationInfo.getGridCoverageMaxY()});
            return factory.create((CharSequence)this.tiledLayer.createCommonUrl(), (RenderedImage)coverageImage, (Envelope)gridEnvelope, null, null, null);
        }
        catch (Exception e) {
            throw ExceptionUtils.getRuntimeException(e);
        }
    }

    public static final class Tile {
        private final BufferedImage image;
        private final int xIndex;
        private final int yIndex;

        private Tile(BufferedImage image, int xIndex, int yIndex) {
            this.image = image;
            this.xIndex = xIndex;
            this.yIndex = yIndex;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public int getxIndex() {
            return this.xIndex;
        }

        public int getyIndex() {
            return this.yIndex;
        }
    }

    public static class PlaceHolderImageTask
    extends TileTask {
        private final BufferedImage placeholderImage;

        public PlaceHolderImageTask(BufferedImage placeholderImage, int tileOriginX, int tileOriginY) {
            super(tileOriginX, tileOriginY);
            this.placeholderImage = placeholderImage;
        }

        @Override
        protected final Tile compute() {
            return new Tile(this.placeholderImage, this.getTileIndexX(), this.getTileIndexY());
        }
    }

    public static final class SingleTileLoaderTask
    extends TileTask {
        private final ClientHttpRequest tileRequest;
        private final boolean failOnError;
        private final MetricRegistry registry;
        private final String jobId;
        private final BufferedImage errorImage;

        public SingleTileLoaderTask(ClientHttpRequest tileRequest, BufferedImage errorImage, int tileIndexX, int tileIndexY, boolean failOnError, MetricRegistry registry, String jobId) {
            super(tileIndexX, tileIndexY);
            this.tileRequest = tileRequest;
            this.errorImage = errorImage;
            this.failOnError = failOnError;
            this.registry = registry;
            this.jobId = jobId;
        }

        @Override
        protected Tile compute() {
            MDC.put((String)"job_id", (String)this.jobId);
            String baseMetricName = TilePreparationTask.class.getName() + ".read." + this.tileRequest.getURI().getHost();
            try (ClientHttpResponse response = null;){
                LOGGER.debug("\n\t" + this.tileRequest.getMethod() + " -- " + this.tileRequest.getURI());
                Timer.Context timerDownload = this.registry.timer(baseMetricName).time();
                response = this.tileRequest.execute();
                HttpStatus statusCode = response.getStatusCode();
                if (statusCode == HttpStatus.NO_CONTENT || statusCode == HttpStatus.NOT_FOUND) {
                    if (statusCode == HttpStatus.NOT_FOUND) {
                        LOGGER.info("The request {} returns a not found status code, we consider it as an empty tile.", (Object)this.tileRequest.getURI());
                    }
                    Tile tile = new Tile(null, this.getTileIndexX(), this.getTileIndexY());
                    return tile;
                }
                if (statusCode != HttpStatus.OK) {
                    String errorMessage = String.format("Error making tile request: %s\n\tStatus: %s\n\toutMessage: %s", this.tileRequest.getURI(), statusCode, response.getStatusText());
                    LOGGER.error(errorMessage);
                    this.registry.counter(baseMetricName + ".error").inc();
                    if (this.failOnError) {
                        throw new RuntimeException(errorMessage);
                    }
                    Tile tile = new Tile(this.errorImage, this.getTileIndexX(), this.getTileIndexY());
                    return tile;
                }
                BufferedImage image = ImageIO.read(response.getBody());
                if (image == null) {
                    LOGGER.warn(String.format("The URL: %s is an image format that cannot be decoded", this.tileRequest.getURI()));
                    image = this.errorImage;
                    this.registry.counter(baseMetricName + ".error").inc();
                } else {
                    timerDownload.stop();
                }
                Tile tile = new Tile(image, this.getTileIndexX(), this.getTileIndexY());
                return tile;
            }
        }
    }

    public static abstract class TileTask
    extends RecursiveTask<Tile>
    implements Callable<Tile> {
        private final int tileIndexX;
        private final int tileIndexY;

        public TileTask(int tileIndexX, int tileIndexY) {
            this.tileIndexX = tileIndexX;
            this.tileIndexY = tileIndexY;
        }

        public final int getTileIndexX() {
            return this.tileIndexX;
        }

        public final int getTileIndexY() {
            return this.tileIndexY;
        }

        @Override
        public final Tile call() throws Exception {
            return (Tile)this.compute();
        }
    }
}

