/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.tiled.osm;

import com.codahale.metrics.MetricRegistry;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.mapfish.print.URIUtils;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.config.Configuration;
import org.mapfish.print.http.MfClientHttpRequestFactory;
import org.mapfish.print.map.geotools.StyleSupplier;
import org.mapfish.print.map.tiled.AbstractTiledLayer;
import org.mapfish.print.map.tiled.TileCacheInformation;
import org.mapfish.print.map.tiled.osm.OsmLayerParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;

public final class OsmLayer
extends AbstractTiledLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsmLayer.class);
    private final OsmLayerParam param;

    public OsmLayer(@Nonnull ForkJoinPool forkJoinPool, @Nonnull StyleSupplier<GridCoverage2D> styleSupplier, @Nonnull OsmLayerParam param, @Nonnull MetricRegistry registry, @Nonnull Configuration configuration) {
        super(forkJoinPool, styleSupplier, param, registry, configuration);
        this.param = param;
    }

    @Override
    protected TileCacheInformation createTileInformation(MapBounds bounds, Rectangle paintArea, double dpi) {
        return new OsmTileCacheInformation(bounds, paintArea, dpi);
    }

    @Override
    public MapLayer.RenderType getRenderType() {
        return MapLayer.RenderType.fromFileExtension(this.param.imageExtension);
    }

    private final class OsmTileCacheInformation
    extends TileCacheInformation {
        private final double resolution;
        private final int resolutionIndex;

        public OsmTileCacheInformation(MapBounds bounds, Rectangle paintArea, double dpi) {
            super(bounds, paintArea, dpi, OsmLayer.this.param);
            double targetResolution = bounds.getScale(paintArea, dpi).getResolution();
            Double[] resolutions = ((OsmLayer)OsmLayer.this).param.resolutions;
            int pos = resolutions.length - 1;
            double result = resolutions[pos];
            for (int i = resolutions.length - 1; i >= 0; --i) {
                double cur = resolutions[i];
                if (!(cur <= targetResolution * ((OsmLayer)OsmLayer.this).param.resolutionTolerance)) continue;
                result = cur;
                pos = i;
                OsmLayer.this.imageBufferScaling = cur / targetResolution;
            }
            this.resolution = result;
            this.resolutionIndex = pos;
        }

        @Override
        @Nonnull
        public ClientHttpRequest getTileRequest(MfClientHttpRequestFactory httpRequestFactory, String commonUrl, ReferencedEnvelope tileBounds, Dimension tileSizeOnScreen, int column, int row) throws IOException, URISyntaxException {
            URI uri;
            if (commonUrl.contains("{x}") && commonUrl.contains("{z}") && (commonUrl.contains("{y}") || commonUrl.contains("{-y}"))) {
                String url = commonUrl.replace("{z}", Integer.toString(this.resolutionIndex)).replace("{x}", Integer.toString(column)).replace("{y}", Integer.toString(row));
                if (commonUrl.contains("{-y}")) {
                    url = url.replace("{-y}", Integer.toString((int)Math.pow(2.0, this.resolutionIndex) - 1 - row));
                }
                uri = new URI(url);
            } else {
                StringBuilder path = new StringBuilder();
                if (!commonUrl.endsWith("/")) {
                    path.append('/');
                }
                path.append(this.resolutionIndex);
                path.append('/').append(column);
                path.append('/').append(row);
                path.append('.').append(((OsmLayer)OsmLayer.this).param.imageExtension);
                uri = new URI(commonUrl + path.toString());
            }
            return httpRequestFactory.createRequest(URIUtils.addParams(uri, OsmLayerParam.convertToMultiMap(((OsmLayer)OsmLayer.this).param.customParams), (Set<String>)URIUtils.getParameters(uri).keySet()), HttpMethod.GET);
        }

        @Override
        public double getResolution() {
            return this.resolution;
        }

        @Override
        public Double getLayerDpi() {
            return ((OsmLayer)OsmLayer.this).param.dpi;
        }

        @Override
        public Dimension getTileSize() {
            return OsmLayer.this.param.getTileSize();
        }

        @Override
        @Nonnull
        protected ReferencedEnvelope getTileCacheBounds() {
            return new ReferencedEnvelope(OsmLayer.this.param.getMaxExtent(), this.bounds.getProjection());
        }
    }
}

