/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.parser;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.mapfish.print.parser.HasDefaultValue;

public final class ParserUtils {
    public static final com.google.common.base.Predicate<Field> FILTER_ONLY_REQUIRED_ATTRIBUTES = new com.google.common.base.Predicate<Field>(){

        public boolean apply(@Nullable Field input) {
            return input != null && input.getAnnotation(HasDefaultValue.class) == null && !Modifier.isFinal(input.getModifiers());
        }
    };
    public static final com.google.common.base.Predicate<Field> FILTER_HAS_DEFAULT_ATTRIBUTES = new com.google.common.base.Predicate<Field>(){

        public boolean apply(@Nullable Field input) {
            return input != null && input.getAnnotation(HasDefaultValue.class) != null;
        }
    };
    public static final com.google.common.base.Predicate<Field> FILTER_NON_FINAL_FIELDS = new com.google.common.base.Predicate<Field>(){

        public boolean apply(@Nullable Field input) {
            return input != null && !Modifier.isFinal(input.getModifiers());
        }
    };
    public static final com.google.common.base.Predicate<Field> FILTER_FINAL_FIELDS = new com.google.common.base.Predicate<Field>(){

        public boolean apply(@Nullable Field input) {
            return input != null && Modifier.isFinal(input.getModifiers());
        }
    };
    private static final Function<Field, String> FIELD_TO_NAME = new Function<Field, String>(){

        @Nullable
        public String apply(Field input) {
            return input.getName();
        }
    };

    private ParserUtils() {
    }

    public static Collection<Field> getAllAttributes(Class<?> classToInspect) {
        HashSet allFields = Sets.newHashSet();
        ParserUtils.getAllAttributes(classToInspect, allFields, Functions.identity(), field -> true);
        return allFields;
    }

    public static Collection<Field> getAttributes(Class<?> classToInspect, com.google.common.base.Predicate<Field> filter) {
        HashSet allFields = Sets.newHashSet();
        ParserUtils.getAllAttributes(classToInspect, allFields, Functions.identity(), arg_0 -> filter.test(arg_0));
        return allFields;
    }

    private static <V> void getAllAttributes(Class<?> classToInspect, Set<V> results, Function<Field, V> map, Predicate<Field> filter) {
        if (classToInspect != null && classToInspect != Void.class) {
            Collection filteredResults = Collections2.filter(Arrays.asList(classToInspect.getFields()), filter::test);
            Collection resultsForClass = Collections2.transform((Collection)filteredResults, map);
            results.addAll(resultsForClass);
            if (classToInspect.getSuperclass() != null) {
                ParserUtils.getAllAttributes(classToInspect.getSuperclass(), results, map, filter);
            }
        }
    }

    public static Set<String> getAllAttributeNames(Class<?> classToInspect) {
        HashSet allFields = Sets.newHashSet();
        ParserUtils.getAllAttributes(classToInspect, allFields, FIELD_TO_NAME, field -> true);
        return allFields;
    }

    public static Set<String> getAttributeNames(Class<?> classToInspect, Predicate<Field> filter) {
        HashSet allFields = Sets.newHashSet();
        ParserUtils.getAllAttributes(classToInspect, allFields, FIELD_TO_NAME, filter);
        return allFields;
    }
}

