/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.servlet.oldapi;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mapfish.print.FloatingPointUtil;
import org.mapfish.print.config.OldApiConfig;
import org.mapfish.print.wrapper.json.PJsonObject;

public final class OldAPILayerConverter {
    private static Map<String, LayerConverter> converters = new HashMap<String, LayerConverter>();

    private OldAPILayerConverter() {
    }

    public static JSONObject convert(PJsonObject oldLayer, OldApiConfig oldApi) throws JSONException {
        String layerType = oldLayer.optString("type", "").toLowerCase();
        if (!converters.containsKey(layerType)) {
            throw new UnsupportedOperationException("Layer type '" + layerType + "' is not supported by the legacy API.");
        }
        return converters.get(layerType).convert(oldLayer, oldApi);
    }

    static {
        converters.put("osm", new OSMConverter());
        converters.put("xyz", new OSMConverter());
        converters.put("wms", new WMSConverter());
        converters.put("wmts", new WMSTConverter());
        converters.put("vector", new GeoJsonConverter());
        converters.put("image", new GeoImageConverter());
    }

    private static class WMSTConverter
    extends AbstractLayerConverter {
        private WMSTConverter() {
        }

        @Override
        public final JSONObject convert(PJsonObject oldLayer, OldApiConfig oldApi) throws JSONException {
            JSONObject layer = super.convert(oldLayer, oldApi);
            layer.put("type", (Object)"wmts");
            if (oldLayer.has("baseURL")) {
                layer.put("baseURL", (Object)oldLayer.getString("baseURL"));
            }
            if (oldLayer.has("opacity")) {
                layer.put("opacity", oldLayer.getDouble("opacity"));
            }
            if (oldLayer.has("layer")) {
                layer.put("layer", (Object)oldLayer.getString("layer"));
            }
            if (oldLayer.has("format")) {
                String format = oldLayer.getString("format");
                if (format.toLowerCase().startsWith("image/")) {
                    layer.put("imageFormat", (Object)format);
                } else {
                    layer.put("imageFormat", (Object)("image/" + format));
                }
            }
            if (oldLayer.has("style")) {
                layer.put("style", (Object)oldLayer.getString("style"));
            }
            if (oldLayer.has("requestEncoding")) {
                layer.put("requestEncoding", (Object)oldLayer.getString("requestEncoding"));
            }
            if (oldLayer.has("customParams")) {
                JSONObject customParams = oldLayer.getInternalObj().getJSONObject("customParams");
                if (customParams.has("version")) {
                    layer.put("version", (Object)customParams.getString("version"));
                    customParams.remove("version");
                }
                layer.put("customParams", (Object)customParams);
            }
            layer.put("dimensions", JSONObject.NULL);
            layer.put("dimensionParams", (Object)new JSONObject());
            if (oldLayer.has("matrixSet")) {
                layer.put("matrixSet", (Object)oldLayer.getString("matrixSet"));
            }
            if (oldLayer.has("matrixSet")) {
                layer.put("matrices", (Object)this.convertMatrices(oldLayer.getInternalObj().getJSONArray("matrixIds")));
            }
            return layer;
        }

        private JSONArray convertMatrices(JSONArray oldMatrices) {
            JSONArray matrices = new JSONArray();
            if (oldMatrices != null && oldMatrices.length() > 0) {
                for (int i = 0; i < oldMatrices.length(); ++i) {
                    JSONObject matrix = this.convertMatrix(oldMatrices.optJSONObject(i));
                    if (matrix == null) continue;
                    matrices.put((Object)matrix);
                }
            }
            return matrices;
        }

        private JSONObject convertMatrix(JSONObject old) {
            JSONObject matrix = null;
            try {
                if (old != null) {
                    matrix = new JSONObject();
                    if (old.has("identifier")) {
                        matrix.put("identifier", (Object)old.optString("identifier"));
                    }
                    if (old.has("matrixSize")) {
                        matrix.put("matrixSize", (Object)old.optJSONArray("matrixSize"));
                    }
                    if (old.has("scaleDenominator")) {
                        matrix.put("scaleDenominator", old.optDouble("scaleDenominator", 0.0));
                    }
                    if (old.has("resolution") && !old.has("scaleDenominator")) {
                        Double scaleDenominator = 0.0;
                        Double resolution = old.optDouble("resolution", 0.0);
                        if (!FloatingPointUtil.equals(resolution, 0.0)) {
                            double conversionRatio = 2.8E-4;
                            scaleDenominator = resolution / 2.8E-4;
                        }
                        matrix.put("scaleDenominator", (Object)scaleDenominator);
                    }
                    if (old.has("tileSize")) {
                        matrix.put("tileSize", (Object)old.optJSONArray("tileSize"));
                    }
                    if (old.has("topLeftCorner")) {
                        matrix.put("topLeftCorner", (Object)old.optJSONArray("topLeftCorner"));
                    }
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return matrix;
        }
    }

    private static class GeoJsonConverter
    extends AbstractLayerConverter {
        private GeoJsonConverter() {
        }

        @Override
        public final JSONObject convert(PJsonObject oldLayer, OldApiConfig oldApi) throws JSONException {
            JSONObject layer = super.convert(oldLayer, oldApi);
            layer.put("type", (Object)"geojson");
            if (oldLayer.has("geoJson")) {
                try {
                    layer.put("geoJson", (Object)oldLayer.getInternalObj().getJSONObject("geoJson"));
                }
                catch (JSONException e) {
                    layer.put("geoJson", (Object)oldLayer.getString("geoJson"));
                }
            }
            if (oldLayer.has("styles")) {
                JSONObject styles = oldLayer.getInternalObj().getJSONObject("styles");
                if (oldLayer.has("styleProperty")) {
                    styles.put("styleProperty", (Object)oldLayer.getString("styleProperty"));
                }
                styles.put("version", (Object)"1");
                layer.put("style", (Object)styles);
                oldLayer.getInternalObj().remove("styles");
            }
            return layer;
        }
    }

    private static class WMSConverter
    extends AbstractLayerConverter {
        private WMSConverter() {
        }

        @Override
        public final JSONObject convert(PJsonObject oldLayer, OldApiConfig oldApi) throws JSONException {
            JSONArray stylesJson;
            JSONObject layer = super.convert(oldLayer, oldApi);
            layer.put("type", (Object)"wms");
            if (oldLayer.has("isTiled") && oldLayer.getInternalObj().getBoolean("isTiled")) {
                layer.put("type", (Object)"tiledwms");
                if (oldLayer.has("tileSize")) {
                    layer.put("tileSize", (Object)oldLayer.getInternalObj().getJSONArray("tileSize"));
                }
            }
            if (oldLayer.has("baseURL")) {
                layer.put("baseURL", (Object)oldLayer.getString("baseURL"));
            }
            if (oldLayer.has("opacity")) {
                layer.put("opacity", oldLayer.getDouble("opacity"));
            }
            if (oldLayer.has("layers")) {
                if (oldApi.isWmsReverseLayers()) {
                    layer.put("layers", (Object)this.reverse(oldLayer.getInternalObj().getJSONArray("layers")));
                } else {
                    layer.put("layers", (Object)oldLayer.getInternalObj().getJSONArray("layers"));
                }
            }
            if (oldLayer.has("format")) {
                layer.put("imageFormat", (Object)oldLayer.getString("format"));
            }
            if (oldLayer.has("styles") && ((stylesJson = oldLayer.getInternalObj().getJSONArray("styles")).length() > 1 || stylesJson.length() == 1 && !stylesJson.getString(0).trim().isEmpty())) {
                layer.put("styles", (Object)stylesJson);
            }
            if (oldLayer.has("customParams")) {
                JSONObject customParams = oldLayer.getInternalObj().getJSONObject("customParams");
                if (customParams.has("version")) {
                    layer.put("version", (Object)customParams.getString("version"));
                    customParams.remove("version");
                }
                layer.put("customParams", (Object)customParams);
            }
            if (oldLayer.has("useNativeAngle")) {
                layer.put("useNativeAngle", oldLayer.getBool("useNativeAngle"));
            }
            return layer;
        }

        private JSONArray reverse(JSONArray oldApiLayers) throws JSONException {
            JSONArray newApiLayers = new JSONArray();
            for (int i = oldApiLayers.length(); i > 0; --i) {
                newApiLayers.put(oldApiLayers.get(i - 1));
            }
            return newApiLayers;
        }
    }

    private static class OSMConverter
    extends AbstractLayerConverter {
        private OSMConverter() {
        }

        @Override
        public final JSONObject convert(PJsonObject oldLayer, OldApiConfig oldApi) throws JSONException {
            JSONObject layer = super.convert(oldLayer, oldApi);
            layer.put("type", (Object)"osm");
            if (oldLayer.has("baseURL")) {
                layer.put("baseURL", (Object)oldLayer.getString("baseURL"));
            }
            if (oldLayer.has("opacity")) {
                layer.put("opacity", oldLayer.getDouble("opacity"));
            }
            if (oldLayer.has("extension")) {
                layer.put("imageExtension", (Object)oldLayer.getString("extension"));
            }
            if (oldLayer.has("maxExtent")) {
                layer.put("maxExtent", (Object)oldLayer.getInternalObj().getJSONArray("maxExtent"));
            }
            if (oldLayer.has("tileSize")) {
                layer.put("tileSize", (Object)oldLayer.getInternalObj().getJSONArray("tileSize"));
            }
            if (oldLayer.has("resolutions")) {
                layer.put("resolutions", (Object)oldLayer.getInternalObj().getJSONArray("resolutions"));
            }
            if (oldLayer.has("customParams")) {
                JSONObject customParams = oldLayer.getInternalObj().getJSONObject("customParams");
                if (customParams.has("version")) {
                    layer.put("version", (Object)customParams.getString("version"));
                    customParams.remove("version");
                }
                layer.put("customParams", (Object)customParams);
            }
            return layer;
        }
    }

    private static class GeoImageConverter
    extends AbstractLayerConverter {
        private GeoImageConverter() {
        }

        @Override
        public JSONObject convert(PJsonObject oldLayer, OldApiConfig oldApi) throws JSONException {
            JSONObject layer = super.convert(oldLayer, oldApi);
            layer.put("type", (Object)"image");
            if (oldLayer.has("baseURL")) {
                layer.put("baseURL", (Object)oldLayer.getString("baseURL"));
            }
            if (oldLayer.has("name")) {
                layer.put("name", (Object)oldLayer.getString("name"));
            }
            if (oldLayer.has("opacity")) {
                layer.put("opacity", oldLayer.getDouble("opacity"));
            }
            if (oldLayer.has("extent")) {
                layer.put("extent", (Object)oldLayer.getInternalObj().getJSONArray("extent"));
            }
            return layer;
        }
    }

    private static abstract class AbstractLayerConverter
    implements LayerConverter {
        private AbstractLayerConverter() {
        }

        @Override
        public JSONObject convert(PJsonObject oldLayer, OldApiConfig oldApi) throws JSONException {
            return new JSONObject();
        }
    }

    private static interface LayerConverter {
        public JSONObject convert(PJsonObject var1, OldApiConfig var2) throws JSONException;
    }
}

