/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import com.google.common.base.Function;
import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.map.AreaOfInterest;
import org.mapfish.print.attribute.map.BBoxMapBounds;
import org.mapfish.print.attribute.map.CenterScaleMapBounds;
import org.mapfish.print.attribute.map.GenericMapAttribute;
import org.mapfish.print.attribute.map.MapBounds;
import org.mapfish.print.attribute.map.MapLayer;
import org.mapfish.print.attribute.map.OverviewMapAttribute;
import org.mapfish.print.attribute.map.ZoomLevelSnapStrategy;
import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.attribute.map.ZoomToFeatures;
import org.mapfish.print.config.Template;
import org.mapfish.print.parser.CanSatisfyOneOf;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.OneOf;
import org.mapfish.print.parser.Requires;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.json.PJsonArray;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class MapAttribute
extends GenericMapAttribute {
    private static final double DEFAULT_SNAP_TOLERANCE = 0.05;
    private static final ZoomLevelSnapStrategy DEFAULT_SNAP_STRATEGY = ZoomLevelSnapStrategy.CLOSEST_LOWER_SCALE_ON_TIE;
    private static final boolean DEFAULT_SNAP_GEODETIC = false;

    @Override
    public Class<MapAttributeValues> getValueType() {
        return MapAttributeValues.class;
    }

    @Override
    public MapAttributeValues createValue(Template template) {
        return new MapAttributeValues(template, this.getWidth(), this.getHeight());
    }

    public class OverriddenMapAttributeValues
    extends MapAttributeValues {
        private final MapAttributeValues params;
        private final OverviewMapAttribute.OverviewMapAttributeValues paramOverrides;
        private MapBounds zoomedOutBounds;
        private MapLayer mapExtentLayer;

        public OverriddenMapAttributeValues(MapAttributeValues params, OverviewMapAttribute.OverviewMapAttributeValues paramOverrides, Template template) {
            super(template, paramOverrides.getWidth(), paramOverrides.getHeight());
            this.zoomedOutBounds = null;
            this.mapExtentLayer = null;
            this.params = params;
            this.paramOverrides = paramOverrides;
        }

        @Override
        public final MapBounds getMapBounds() {
            return this.zoomedOutBounds;
        }

        public final MapBounds getCustomBounds() {
            return this.paramOverrides.getMapBounds();
        }

        public final MapBounds getOriginalBounds() {
            return this.params.getMapBounds();
        }

        public final void setZoomedOutBounds(MapBounds zoomedOutBounds) {
            this.zoomedOutBounds = zoomedOutBounds;
        }

        @Override
        public final Double getDpi() {
            return this.getValueOr(this.paramOverrides.getDpi(), this.params.getDpi());
        }

        @Override
        public final Double getZoomSnapTolerance() {
            return this.getValueOr(this.paramOverrides.getZoomSnapTolerance(), this.params.getZoomSnapTolerance());
        }

        @Override
        public final ZoomLevelSnapStrategy getZoomLevelSnapStrategy() {
            return this.getValueOr(this.paramOverrides.getZoomLevelSnapStrategy(), this.params.getZoomLevelSnapStrategy());
        }

        @Override
        public final ZoomLevels getZoomLevels() {
            return this.getValueOr(this.paramOverrides.getZoomLevels(), this.params.getZoomLevels());
        }

        @Override
        public final Double getRotation() {
            return this.getValueOr(this.paramOverrides.getRotation(), this.params.getRotation());
        }

        @Override
        public final Boolean isUseAdjustBounds() {
            return this.getValueOr(this.paramOverrides.isUseAdjustBounds(), this.params.isUseAdjustBounds());
        }

        @Override
        public final Boolean isUseNearestScale() {
            Boolean useNearestScale = this.getValueOr(this.paramOverrides.useNearestScale, this.params.useNearestScale);
            return (useNearestScale == null || useNearestScale != false) && this.getZoomLevels() != null;
        }

        public final void setMapExtentLayer(MapLayer mapExtentLayer) {
            this.mapExtentLayer = mapExtentLayer;
        }

        @Override
        public final List<MapLayer> getLayers() {
            ArrayList<MapLayer> layers = new ArrayList<MapLayer>();
            if (this.mapExtentLayer != null) {
                layers.add(this.mapExtentLayer);
            }
            if (!this.paramOverrides.getLayers().isEmpty()) {
                layers.addAll(this.paramOverrides.getLayers());
            } else {
                layers.addAll(this.params.getLayers());
            }
            return layers;
        }
    }

    public class MapAttributeValues
    extends GenericMapAttribute.GenericMapAttributeValues {
        private static final boolean DEFAULT_ADJUST_BOUNDS = false;
        private static final double DEFAULT_ROTATION = 0.0;
        private MapBounds mapBounds;
        @OneOf(value="MapBounds")
        public double[] bbox;
        @CanSatisfyOneOf(value="MapBounds")
        @HasDefaultValue
        public AreaOfInterest areaOfInterest;
        @Requires(value={"scale"})
        @OneOf(value="MapBounds")
        public double[] center;
        @HasDefaultValue
        public Double scale;
        @OneOf(value="MapBounds")
        public ZoomToFeatures zoomToFeatures;
        @HasDefaultValue
        public PArray layers;
        public double dpi;

        public MapAttributeValues(Template template, Integer width, Integer height) {
            super(MapAttribute.this, template, width, height);
            this.layers = new PJsonArray(null, new JSONArray(), null);
        }

        public MapAttributeValues(Template template) {
            super(MapAttribute.this, template);
            this.layers = new PJsonArray(null, new JSONArray(), null);
        }

        @Override
        public Double getDpi() {
            return this.dpi;
        }

        @Override
        public final PArray getRawLayers() {
            return this.layers;
        }

        @Override
        public void setRawLayers(PArray newLayers) {
            this.layers = newLayers;
        }

        @Override
        public final void postConstruct() throws FactoryException {
            super.postConstruct();
            if (this.getDpi() > MapAttribute.this.getMaxDpi()) {
                throw new IllegalArgumentException("dpi parameter was " + this.getDpi() + " must be limited to " + MapAttribute.this.getMaxDpi() + ".  The path to the parameter is: " + this.getDpi());
            }
            if (this.zoomToFeatures != null) {
                if (this.zoomToFeatures.zoomType == ZoomToFeatures.ZoomType.CENTER) {
                    if (this.scale == null && this.zoomToFeatures.minScale == null) {
                        throw new IllegalArgumentException("When using 'zoomToFeatures.zoom.Type: center' either 'scale' or 'zoomToFeatures.minScale' has to be given.");
                    }
                } else if (this.zoomToFeatures.zoomType == ZoomToFeatures.ZoomType.EXTENT && this.zoomToFeatures.minScale == null) {
                    throw new IllegalArgumentException("When using 'zoomToFeatures.zoom.Type: extent' 'zoomToFeatures.minScale'has to be given.");
                }
            }
            this.mapBounds = this.parseBounds();
        }

        private MapBounds parseBounds() throws FactoryException {
            MapBounds bounds;
            CoordinateReferenceSystem crs = this.parseProjection();
            if (this.center != null && this.bbox != null) {
                throw new IllegalArgumentException("Cannot have both center and bbox defined");
            }
            if (this.center != null) {
                double centerX = this.center[0];
                double centerY = this.center[1];
                bounds = new CenterScaleMapBounds(crs, centerX, centerY, this.scale);
            } else if (this.bbox != null) {
                int maxYIndex = 3;
                double minX = this.bbox[0];
                double minY = this.bbox[1];
                double maxX = this.bbox[2];
                double maxY = this.bbox[3];
                bounds = new BBoxMapBounds(crs, minX, minY, maxX, maxY);
            } else if (this.areaOfInterest != null) {
                Envelope area = this.areaOfInterest.getArea().getEnvelopeInternal();
                bounds = new BBoxMapBounds(crs, area);
            } else if (this.zoomToFeatures != null) {
                bounds = new BBoxMapBounds(crs, 0.0, 0.0, 10.0, 10.0);
            } else {
                throw new IllegalArgumentException("Expected either: center and scale, bbox, or an areaOfInterest defined in order to calculate the map bounds");
            }
            return bounds;
        }

        public MapBounds getMapBounds() {
            return this.mapBounds;
        }

        public void setMapBounds(MapBounds mapBounds) {
            this.mapBounds = mapBounds;
        }

        public void recalculateBounds() {
            try {
                this.mapBounds = this.parseBounds();
            }
            catch (FactoryException e) {
                throw ExceptionUtils.getRuntimeException(e);
            }
        }

        @Override
        public String getProjection() {
            return this.getValueOr(super.getProjection(), "EPSG:3857");
        }

        @Override
        public Double getZoomSnapTolerance() {
            return this.getValueOr(super.getZoomSnapTolerance(), 0.05);
        }

        @Override
        public ZoomLevelSnapStrategy getZoomLevelSnapStrategy() {
            return this.getValueOr(super.getZoomLevelSnapStrategy(), DEFAULT_SNAP_STRATEGY);
        }

        @Override
        public Boolean getZoomSnapGeodetic() {
            return this.getValueOr(super.getZoomSnapGeodetic(), false);
        }

        @Override
        public Double getRotation() {
            return this.getValueOr(super.getRotation(), 0.0);
        }

        @Override
        public Boolean isUseNearestScale() {
            return (this.useNearestScale == null || this.useNearestScale != false) && this.getZoomLevels() != null;
        }

        @Override
        public Boolean isUseAdjustBounds() {
            return this.getValueOr(super.isUseAdjustBounds(), false);
        }

        public final OverriddenMapAttributeValues getWithOverrides(OverviewMapAttribute.OverviewMapAttributeValues paramOverrides) {
            return new OverriddenMapAttributeValues(this, paramOverrides, this.getTemplate());
        }

        public MapAttributeValues copy(int width, int height, @Nonnull Function<MapAttributeValues, Void> updater) {
            MapAttributeValues copy = new MapAttributeValues(this.getTemplate(), (Integer)width, (Integer)height);
            copy.areaOfInterest = this.areaOfInterest.copy();
            copy.bbox = this.bbox;
            copy.center = this.center;
            copy.scale = this.scale;
            copy.layers = this.layers;
            copy.dpi = this.getDpi();
            copy.projection = this.getProjection();
            copy.rotation = this.getRotation();
            copy.useNearestScale = this.isUseNearestScale();
            copy.useAdjustBounds = this.useAdjustBounds;
            copy.longitudeFirst = this.longitudeFirst;
            copy.zoomToFeatures = this.zoomToFeatures == null ? null : this.zoomToFeatures.copy();
            updater.apply((Object)copy);
            try {
                copy.postConstruct();
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
            return copy;
        }
    }
}

