/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute.map;

import org.mapfish.print.attribute.map.ZoomLevels;
import org.mapfish.print.map.DistanceUnit;
import org.mapfish.print.map.Scale;

public enum ZoomLevelSnapStrategy {
    CLOSEST_LOWER_SCALE_ON_TIE{

        @Override
        protected SearchResult search(Scale scale, double tolerance, ZoomLevels zoomLevels) {
            double resolution = scale.getResolution();
            int pos = -1;
            double distance = Double.POSITIVE_INFINITY;
            for (int i = zoomLevels.size() - 1; i >= 0; --i) {
                Scale cur = zoomLevels.get(i, scale.getUnit());
                double newDistance = Math.abs(resolution - cur.getResolution());
                if (!(newDistance < distance)) continue;
                distance = newDistance;
                pos = i;
                if (distance < 1.0E-11) break;
            }
            return new SearchResult(pos, zoomLevels);
        }
    }
    ,
    CLOSEST_HIGHER_SCALE_ON_TIE{

        @Override
        protected SearchResult search(Scale scale, double tolerance, ZoomLevels zoomLevels) {
            double resolution = scale.getResolution();
            int pos = -1;
            double distance = Double.POSITIVE_INFINITY;
            for (int i = 0; i < zoomLevels.size(); ++i) {
                Scale cur = zoomLevels.get(i, scale.getUnit());
                double newDistance = Math.abs(resolution - cur.getResolution());
                if (!(newDistance < distance)) continue;
                distance = newDistance;
                pos = i;
                if (distance < 1.0E-11) break;
            }
            return new SearchResult(pos, zoomLevels);
        }
    }
    ,
    HIGHER_SCALE{

        @Override
        protected SearchResult search(Scale scale, double tolerance, ZoomLevels zoomLevels) {
            double cutOff = scale.getResolution() * (1.0 - tolerance);
            int pos = zoomLevels.size() - 1;
            for (int i = zoomLevels.size() - 1; i >= 0; --i) {
                Scale cur = zoomLevels.get(i, scale.getUnit());
                if (!(cur.getResolution() >= cutOff)) continue;
                pos = i;
                break;
            }
            return new SearchResult(pos, zoomLevels);
        }
    }
    ,
    LOWER_SCALE{

        @Override
        protected SearchResult search(Scale scale, double tolerance, ZoomLevels zoomLevels) {
            double cutOff = scale.getResolution() * (1.0 + tolerance);
            int pos = -1;
            for (int i = 0; i < zoomLevels.size(); ++i) {
                Scale cur = zoomLevels.get(i, scale.getUnit());
                if (!(cur.getResolution() <= cutOff)) continue;
                pos = i;
                break;
            }
            return new SearchResult(pos, zoomLevels);
        }
    };


    protected abstract SearchResult search(Scale var1, double var2, ZoomLevels var4);

    private static class Constants {
        private static final double DISTANCE_TREATED_AS_EQUAL = 1.0E-11;

        private Constants() {
        }
    }

    public static final class SearchResult {
        private final int zoomLevel;
        private final ZoomLevels zoomLevels;

        SearchResult(int zoomLevel, ZoomLevels zoomLevels) {
            this.zoomLevel = zoomLevel;
            this.zoomLevels = zoomLevels;
        }

        public int getZoomLevel() {
            return this.zoomLevel;
        }

        public ZoomLevels getZoomLevels() {
            return this.zoomLevels;
        }

        public Scale getScale(DistanceUnit unit) {
            return this.zoomLevels.get(this.zoomLevel, unit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchResult that = (SearchResult)o;
            return this.zoomLevel == that.zoomLevel && this.zoomLevels.equals(that.zoomLevels);
        }

        public int hashCode() {
            int result = this.zoomLevel;
            result = 31 * result + this.zoomLevels.hashCode();
            return result;
        }

        public String toString() {
            return String.format("SearchResult{zoomLevel=%s, scale=%s, zoomLevels=%s}", this.zoomLevel, this.zoomLevels.get(this.zoomLevel, DistanceUnit.M), this.zoomLevels);
        }
    }
}

