/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.geotools.grid;

import com.vividsolutions.jts.util.Assert;
import java.util.Arrays;
import java.util.IllegalFormatException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.mapfish.print.map.AbstractLayerParams;
import org.mapfish.print.map.geotools.grid.GridFontParam;
import org.mapfish.print.map.geotools.grid.GridLabelFormat;
import org.mapfish.print.map.geotools.grid.GridLayer;
import org.mapfish.print.map.geotools.grid.GridType;
import org.mapfish.print.parser.HasDefaultValue;
import org.mapfish.print.parser.OneOf;
import org.mapfish.print.parser.Requires;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public final class GridParam
extends AbstractLayerParams {
    private static final int DEFAULT_POINTS_IN_GRID_LINE = 10000;
    private static final int DEFAULT_HALO_RADIUS = 1;
    private static final int DEFAULT_INDENT = 5;
    private static final String DEFAULT_HALO_COLOR = "#FFF";
    private static final String DEFAULT_LABEL_COLOR = "#444";
    private static final String DEFAULT_GRID_COLOR = "gray";
    public static final String DEFAULT_UNIT_FORMAT = " %s";
    @HasDefaultValue
    public GridType gridType = GridType.LINES;
    @OneOf(value="spacing")
    @Requires(value={"origin"})
    public double[] spacing;
    @HasDefaultValue
    public double[] origin;
    @OneOf(value="spacing")
    public int[] numberOfLines;
    @HasDefaultValue
    public String style;
    @HasDefaultValue
    public Boolean renderAsSvg = false;
    @HasDefaultValue
    public int pointsInLine = 10000;
    @HasDefaultValue
    public double haloRadius = 1.0;
    @HasDefaultValue
    public String haloColor = "#FFF";
    @HasDefaultValue
    public String labelColor = "#444";
    @HasDefaultValue
    public String gridColor = "gray";
    @HasDefaultValue
    public GridFontParam font = new GridFontParam();
    @HasDefaultValue
    public int indent = 5;
    @HasDefaultValue
    public String labelProjection = null;
    @HasDefaultValue
    public String labelFormat = null;
    @HasDefaultValue
    public String valueFormat = null;
    @HasDefaultValue
    public String unitFormat = null;
    @HasDefaultValue
    public String formatDecimalSeparator = null;
    @HasDefaultValue
    public String formatGroupingSeparator = null;
    @HasDefaultValue
    public Boolean longitudeFirst = null;
    private GridLabelFormat gridLabelFormat = null;
    private CoordinateReferenceSystem labelCRS;
    @HasDefaultValue
    public boolean rotateLabels = true;
    @HasDefaultValue
    public double verticalXOffset = 0.0;
    @HasDefaultValue
    public double horizontalYOffset = 0.0;

    public void postConstruct() {
        Assert.isTrue((this.spacing == null || this.spacing.length == 2 ? 1 : 0) != 0, (String)(GridLayer.class.getSimpleName() + ".spacing has the wrong number of elements.  Expected 2 (x,y) but was: " + Arrays.toString(this.spacing)));
        Assert.isTrue((this.numberOfLines == null || this.numberOfLines.length == 2 ? 1 : 0) != 0, (String)(GridLayer.class.getSimpleName() + ".numberOfLines has the wrong number of elements.  Expected 2 (x,y) but was: " + Arrays.toString(this.numberOfLines)));
        Assert.isTrue((this.pointsInLine > 2 ? 1 : 0) != 0, (String)("There must be at least 2 points in a line.  There were: " + this.pointsInLine));
        Assert.isTrue((this.indent >= 0 ? 1 : 0) != 0, (String)("The indent is not permitted to be negative: " + this.indent));
        Assert.isTrue((this.labelColor != null ? 1 : 0) != 0, (String)"labelColor should not be null");
        Assert.isTrue((this.haloColor != null ? 1 : 0) != 0, (String)"haloColor should not be null");
        Assert.isTrue((this.font != null ? 1 : 0) != 0, (String)"font should not be null");
        try {
            if (this.labelProjection != null) {
                this.labelCRS = this.longitudeFirst != null ? CRS.decode((String)this.labelProjection, (boolean)this.longitudeFirst) : CRS.decode((String)this.labelProjection);
            }
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException("The projection code: " + this.labelProjection + " is not valid. Error message when parsing code: " + e.getMessage());
        }
        if (this.labelFormat != null || this.valueFormat != null || this.unitFormat != null) {
            GridLabelFormat format = GridLabelFormat.fromConfig(this);
            if (format == null) {
                throw new IllegalArgumentException("`labelFormat` or `valueFormat` must be set");
            }
            try {
                format.format(2.0, "m");
            }
            catch (IllegalFormatException e) {
                throw new IllegalArgumentException("Invalid label format");
            }
            this.gridLabelFormat = format;
        }
    }

    public String calculateLabelUnit(CoordinateReferenceSystem mapCrs) {
        String unit = this.labelProjection != null ? this.labelCRS.getCoordinateSystem().getAxis(0).getUnit().toString() : mapCrs.getCoordinateSystem().getAxis(0).getUnit().toString();
        return unit;
    }

    public MathTransform calculateLabelTransform(CoordinateReferenceSystem mapCrs) {
        LinearTransform labelTransform;
        if (this.labelProjection != null) {
            try {
                labelTransform = CRS.findMathTransform((CoordinateReferenceSystem)mapCrs, (CoordinateReferenceSystem)this.labelCRS, (boolean)true);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
        } else {
            labelTransform = IdentityTransform.create((int)2);
        }
        return labelTransform;
    }

    public GridLabelFormat getGridLabelFormat() {
        return this.gridLabelFormat;
    }
}

