/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.attribute;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.AssertionFailedException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.ExceptionUtils;
import org.mapfish.print.attribute.Attribute;
import org.mapfish.print.config.Template;
import org.mapfish.print.parser.MapfishParser;
import org.mapfish.print.parser.ParserUtils;
import org.mapfish.print.wrapper.PArray;
import org.mapfish.print.wrapper.PElement;
import org.mapfish.print.wrapper.PObject;
import org.mapfish.print.wrapper.json.PJsonArray;
import org.mapfish.print.wrapper.json.PJsonObject;
import org.mapfish.print.wrapper.multi.PMultiObject;
import org.mapfish.print.wrapper.yaml.PYamlArray;
import org.mapfish.print.wrapper.yaml.PYamlObject;

public abstract class ReflectiveAttribute<Value>
implements Attribute {
    public static final String JSON_NAME = "name";
    public static final String JSON_CLIENT_PARAMS = "clientParams";
    public static final String JSON_CLIENT_INFO = "clientInfo";
    public static final String JSON_ATTRIBUTE_TYPE = "type";
    public static final String JSON_ATTRIBUTE_EMBEDDED_TYPE = "embeddedType";
    public static final String JSON_ATTRIBUTE_DEFAULT = "default";
    public static final String JSON_ATTRIBUTE_IS_ARRAY = "isArray";
    private static final HashSet<Class<? extends Object>> VALUE_OBJ_FIELD_TYPE_THAT_SHOULD_BE_P_TYPE = ReflectiveAttribute.createClassSet(PJsonArray.class, PJsonObject.class, JSONObject.class, JSONArray.class);
    private static final HashSet<Class<? extends Object>> VALUE_OBJ_FIELD_NON_RECURSIVE_TYPE = ReflectiveAttribute.createClassSet(PElement.class, PArray.class, PObject.class);
    private PYamlObject defaults;
    private String configName;

    private static HashSet<Class<? extends Object>> createClassSet(Object ... args) {
        HashSet classes = Sets.newHashSet();
        for (Object arg : args) {
            classes.add((Class)arg);
        }
        return classes;
    }

    private void validateParamObject(Class<?> typeToTest, Set<Class> tested) {
        if (!tested.contains(typeToTest)) {
            Collection<Field> allAttributes = ParserUtils.getAllAttributes(typeToTest);
            Assert.isTrue((!allAttributes.isEmpty() ? 1 : 0) != 0, (String)"An attribute value object must have at least on public field.");
            for (Field attribute : allAttributes) {
                Class<?> type = attribute.getType();
                if (type.isArray()) {
                    type = type.getComponentType();
                }
                if (VALUE_OBJ_FIELD_NON_RECURSIVE_TYPE.contains(type) || this.isJavaType(type)) continue;
                if (VALUE_OBJ_FIELD_TYPE_THAT_SHOULD_BE_P_TYPE.contains(type)) {
                    throw new AssertionFailedException(typeToTest.getName() + "#" + attribute.getName() + " should not be a field in a value object.  Instead use the more general " + PArray.class.getName() + " or " + PObject.class.getName());
                }
                tested.add(type);
                this.validateParamObject(type, tested);
            }
        }
    }

    private boolean isJavaType(Class<?> type) {
        return type.getPackage() == null || type.getPackage().getName().startsWith("java.");
    }

    @PostConstruct
    @VisibleForTesting
    final void init() {
        if (this.defaults == null) {
            this.defaults = new PYamlObject(Collections.emptyMap(), this.getAttributeName());
        }
        this.validateParamObject(this.getValueType(), Sets.newHashSet());
    }

    @Override
    public abstract Class<? extends Value> getValueType();

    public final PObject getDefaultValue() {
        return this.defaults;
    }

    public final void setDefault(Map<String, Object> defaultValue) {
        this.defaults = new PYamlObject(defaultValue, this.getAttributeName());
    }

    @Override
    public final void setConfigName(String configName) {
        this.configName = configName;
    }

    protected final String getAttributeName() {
        return this.getClass().getSimpleName().substring(0, 1).toLowerCase() + this.getClass().getSimpleName().substring(1);
    }

    public abstract Value createValue(Template var1);

    @Override
    public final void printClientConfig(JSONWriter json, Template template) throws JSONException {
        try {
            HashSet printed = Sets.newHashSet();
            Value exampleValue = this.createValue(template);
            json.key(JSON_NAME).value((Object)this.configName);
            json.key(JSON_ATTRIBUTE_TYPE).value((Object)this.getValueType().getSimpleName());
            Class<?> valueType = exampleValue.getClass();
            json.key(JSON_CLIENT_PARAMS);
            json.object();
            this.printClientConfigForType(json, exampleValue, valueType, this.defaults, printed);
            json.endObject();
            Optional<JSONObject> clientOptions = this.getClientInfo();
            if (clientOptions.isPresent()) {
                json.key(JSON_CLIENT_INFO).value(clientOptions.get());
            }
        }
        catch (Throwable e) {
            throw new Error("Error printing the clientConfig of: " + this.getValueType().getName(), e);
        }
    }

    protected Optional<JSONObject> getClientInfo() throws JSONException {
        return Optional.absent();
    }

    private void printClientConfigForType(JSONWriter json, Object exampleValue, Class<?> valueType, PObject defaultValue, Set<Class> printed) throws JSONException, IllegalAccessException {
        Collection<Field> hasDefaultFields;
        Collection<Field> mutableFields = ParserUtils.getAttributes(valueType, ParserUtils.FILTER_ONLY_REQUIRED_ATTRIBUTES);
        if (!mutableFields.isEmpty()) {
            for (Field attribute : mutableFields) {
                this.encodeAttributeValue(true, json, exampleValue, this.getDefaultValue(defaultValue, attribute), attribute, printed);
            }
        }
        if (!(hasDefaultFields = ParserUtils.getAttributes(valueType, ParserUtils.FILTER_HAS_DEFAULT_ATTRIBUTES)).isEmpty()) {
            for (Field attribute : hasDefaultFields) {
                this.encodeAttributeValue(false, json, exampleValue, this.getDefaultValue(defaultValue, attribute), attribute, printed);
            }
        }
    }

    private Object getDefaultValue(PObject defaultValue, Field attribute) {
        if (defaultValue == null) {
            return null;
        }
        return defaultValue.opt(attribute.getName());
    }

    private void encodeAttributeValue(boolean required, JSONWriter json, Object exampleValue, Object defaultValue, Field attribute, Set<Class> printed) throws JSONException, IllegalAccessException {
        Class<?> typeOrComponentType;
        json.key(attribute.getName());
        json.object();
        Class<?> type = attribute.getType();
        Class<?> clazz = typeOrComponentType = type.isArray() ? type.getComponentType() : type;
        if (!VALUE_OBJ_FIELD_NON_RECURSIVE_TYPE.contains(typeOrComponentType) && !this.isJavaType(typeOrComponentType)) {
            if (printed.contains(typeOrComponentType)) {
                json.key(JSON_ATTRIBUTE_TYPE).value((Object)"recursiveDefinition");
            } else {
                HashSet printedForSubTree = Sets.newHashSet(printed);
                printedForSubTree.add(typeOrComponentType);
                json.key(JSON_ATTRIBUTE_TYPE).value((Object)MapfishParser.stringRepresentation(type));
                json.key(JSON_ATTRIBUTE_EMBEDDED_TYPE);
                json.object();
                Object value = attribute.get(exampleValue);
                if (value == null) {
                    if (typeOrComponentType.isEnum()) {
                        if (typeOrComponentType.getEnumConstants().length > 0) {
                            value = typeOrComponentType.getEnumConstants()[0];
                        }
                    } else {
                        try {
                            value = typeOrComponentType.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw ExceptionUtils.getRuntimeException(e);
                        }
                    }
                }
                Object childDefaultValue = this.getDefaultValue((PObject)defaultValue, attribute);
                this.printClientConfigForType(json, value, typeOrComponentType, (PObject)childDefaultValue, printedForSubTree);
                json.endObject();
            }
        } else {
            String typeDescription = this.getTypeDescription(typeOrComponentType);
            json.key(JSON_ATTRIBUTE_TYPE).value((Object)typeDescription);
        }
        if (!required || defaultValue != null) {
            json.key(JSON_ATTRIBUTE_DEFAULT);
            Object valueToAdd = defaultValue;
            if (defaultValue == null) {
                valueToAdd = attribute.get(exampleValue);
            }
            if (valueToAdd instanceof PJsonArray) {
                valueToAdd = ((PJsonArray)valueToAdd).getInternalArray();
            } else if (valueToAdd instanceof PJsonObject) {
                valueToAdd = ((PJsonObject)valueToAdd).getInternalObj();
            } else if (valueToAdd instanceof PYamlObject) {
                valueToAdd = ((PYamlObject)valueToAdd).toJSON().getInternalObj();
            } else if (valueToAdd instanceof PYamlArray) {
                valueToAdd = ((PYamlArray)valueToAdd).toJSON().getInternalArray();
            }
            json.value(valueToAdd);
        }
        if (type.isArray()) {
            json.key(JSON_ATTRIBUTE_IS_ARRAY).value(type.isArray());
        }
        json.endObject();
    }

    private String getTypeDescription(Class<?> type) {
        String typeDescription = PArray.class.isAssignableFrom(type) ? "array" : (PObject.class.isAssignableFrom(type) ? "object" : (Double.class.isAssignableFrom(type) ? "double" : (Integer.class.isAssignableFrom(type) ? "int" : (Boolean.class.isAssignableFrom(type) ? "boolean" : (Byte.class.isAssignableFrom(type) ? "byte" : (Long.class.isAssignableFrom(type) ? "long" : (Float.class.isAssignableFrom(type) ? "float" : MapfishParser.stringRepresentation(type))))))));
        return typeDescription;
    }

    @Override
    public Object getValue(@Nonnull Template template, @Nonnull String attributeName, @Nonnull PObject requestJsonAttributes) {
        boolean errorOnExtraParameters = template.getConfiguration().isThrowErrorOnExtraParameters();
        Value value = this.createValue(template);
        PObject pValue = requestJsonAttributes.optObject(attributeName);
        if (pValue != null) {
            PObject[] pValues = new PObject[]{pValue, this.getDefaultValue()};
            pValue = new PMultiObject(pValues);
        } else {
            Object valueOpt = requestJsonAttributes.opt(attributeName);
            if (valueOpt != null) {
                String valueAsString = valueOpt instanceof PJsonArray ? ((PJsonArray)valueOpt).getInternalArray().toString(2) : (valueOpt instanceof JSONArray ? ((JSONArray)valueOpt).toString(2) : valueOpt.toString());
                String message = "Expected a JSON Object as the value for the element with the path: '" + requestJsonAttributes.getPath(attributeName) + "' but instead got a '" + valueOpt.getClass().toString() + "'.\nThe value is: \n" + valueAsString;
                throw new IllegalArgumentException(message);
            }
            pValue = this.getDefaultValue();
        }
        MapfishParser.parse(errorOnExtraParameters, pValue, value, new String[0]);
        return value;
    }
}

